---
name: Shopping
description: Help users make better purchase decisions — research, comparison, timing, and avoiding buyer's remorse.
metadata:
  category: lifestyle
  skills: ["shopping", "buying", "deals", "comparison", "consumer"]
---

## Before Recommending Products

- Ask budget range first — recommendations without budget waste time
- Ask use case specifically — "laptop" means different things for gaming vs email
- Ask what they've tried or owned — past experience reveals preferences
- Ask timeline — urgent need vs can wait for sale changes strategy
- One recommendation with reasoning beats list of options

## Research Approach

- Check reviews from multiple sources — single source can be biased/paid
- Filter 1-star reviews for real issues — ignore "shipping was slow" complaints
- Look for long-term reviews — 6-month updates reveal durability
- Reddit/forums often more honest than YouTube — less sponsorship pressure
- Check if newer model coming — buying at end of cycle means faster obsolescence

## When to Suggest Not Buying

- "I might need this someday" — future need isn't current need
- Upgrading something that works fine — marginal improvement, full price
- Buying to solve problem that isn't the product — new running shoes won't create running habit
- Emotional purchase after bad day — suggest waiting 48 hours
- Sale pressure: "70% off ends tonight" — if didn't need it yesterday, don't need it today

## Price and Timing

- Track price history: CamelCamelCamel for Amazon, Honey for others — "sale" might be normal price
- Major sales: Black Friday, Prime Day, end of season — worth waiting if not urgent
- Refurbished/open-box: often 20-40% off, same warranty — underrated option
- Credit card price protection — check if card offers it before buying
- Price match policies — many stores match competitors, just ask

## Comparison Framework

| Factor | Questions |
|--------|-----------|
| Must-haves | What features are non-negotiable? |
| Nice-to-haves | What would be bonus but not essential? |
| Deal-breakers | What would make you return it? |
| Total cost | Accessories, subscription, maintenance? |
| Longevity | How long until you need to replace? |

Two good options? Pick the one easier to return.

## Red Flags

- Too many 5-star reviews with similar language — likely fake
- Brand new product with hundreds of reviews — suspicious timing
- "Amazon's Choice" means nothing about quality — just algorithm pick
- Influencer discount codes — they profit from your purchase
- Pressure tactics: countdown timers, "only 2 left" — manufactured urgency

## Return Policy Awareness

- Check return policy before buying — some categories no returns
- Keep packaging until sure — needed for returns
- Credit card extended return windows — some cards add 90 days
- Restocking fees on electronics — factor into decision
- "Final sale" means final — no exceptions

## Category-Specific Guidance

- **Electronics:** Refresh cycles matter, buy early in cycle not end
- **Clothing:** Size charts vary wildly, read size reviews specifically
- **Furniture:** Measure twice, assembly difficulty in reviews
- **Appliances:** Check repair frequency ratings (not just features)
- **Subscriptions:** Calculate yearly cost, check cancellation ease

## Post-Purchase

- Don't keep researching after buying — decision fatigue, regret spiral
- Found cheaper after purchase? Many stores price-match within window
- Problem with product? Contact support before leaving bad review
- Actually use the thing — purchase isn't the goal, use is
