---
name: shopping-price-drop-coupon-scout
description: Track product prices and surface official coupons or discounts without purchasing or account access. Use when a user wants price alerts, deal summaries, or coupon lists for specific items or retailers.
---

# Shopping Price Drop and Coupon Scout

## Goal
Provide a safe, read-only price watch and coupon summary for user-selected products.

## Best fit
- Use when the user provides product URLs or SKUs.
- Use when the user wants a target price and alert plan.
- Use when the user wants official coupon links or promo codes.

## Not fit
- Avoid when the user asks to auto purchase or auto add to cart.
- Avoid when the only data source is prohibited scraping.
- Avoid when payment or login credentials are requested.

## Quick orientation
- `references/overview.md` for workflow and quality bar.
- `references/auth.md` for access and token handling.
- `references/endpoints.md` for optional integrations and templates.
- `references/webhooks.md` for async event handling.
- `references/ux.md` for intake questions and output formats.
- `references/troubleshooting.md` for common issues.
- `references/safety.md` for safety and privacy guardrails.

## Required inputs
- Product list with URLs, SKUs, or names.
- Target price thresholds and currency.
- Preferred retailers or regions.
- Reminder cadence and timezone.

## Expected output
- Price watchlist with target thresholds.
- Price history summary if provided by the user.
- Coupon or promo list from official sources.
- Draft alert messages.

## Operational notes
- Use official retailer APIs or user-provided data exports.
- Do not scrape sites that prohibit automated access.
- Keep outputs as suggestions only.

## Security notes
- Never handle payment details.
- Do not log in to user accounts or store cookies.

## Safe mode
- Track and summarize only.
- Provide coupon lists and alerts without purchases.

## Sensitive ops
- Purchasing, checkout, or cart changes are out of scope.
