# International Customs - Shipping Operations

## Required Data Package

Before cross-border shipment, verify:
- Legal shipper and receiver identity
- Accurate product descriptions by line item
- HS code per item where required
- Country of origin
- Declared value aligned with commercial invoice
- Incoterm and duty/tax payer

Missing any field means higher hold risk.

## Description Quality Rules

Good description pattern:

```text
[Item type] + [material] + [use] + [model/part if relevant]
```

Avoid vague descriptions like:
- gift
- sample
- accessory
- parts

Vague descriptions increase inspection probability.

## Incoterm Quick Guide

| Incoterm | Seller handles | Buyer handles | Typical use |
|----------|----------------|---------------|-------------|
| DDP | Transport + duties + taxes | Receipt only | Premium customer experience |
| DAP | Transport to destination | Duties/taxes on arrival | Cost control with clear disclosure |
| EXW | Pickup availability | Main transport + import process | B2B where buyer controls freight |

Use one incoterm consistently across invoice and carrier docs.

## Customs Failure Prevention

- Keep invoice totals consistent with label declaration.
- Ensure restricted item checks are done before payment capture.
- Attach required licenses or declarations when category requires.
- Avoid under-declaration shortcuts that increase seizure risk.

## Escalation on Hold

If held in customs:
1. Identify specific missing or conflicting document.
2. Provide corrected file in carrier accepted format.
3. Notify customer with concrete next checkpoint.
4. Recalculate ETA and refund/reship threshold.

Track every hold reason for future prevention.
