# Remotion Playbook

Use Remotion as the deterministic finishing layer after AI generation.

## Core capabilities to apply

- Compositions and dynamic props for reusable templates
- Sequencing and transitions for scene pacing
- Text animations and caption overlays
- Audio trimming, fades, and mix control
- Video/image/GIF asset composition
- Rendering via CLI or Node API

## Recommended scene structure

- 0-3s: Hook
- 3-12s: Problem and context
- 12-28s: Product reveal and feature highlights
- 28-40s: Proof and differentiation
- 40s+: CTA hold

## Practical rules

- Keep each scene independent and reusable.
- Drive durations from storyboard -> frames conversion.
- Use spring/interpolate sparingly; prioritize readability.
- Leave safe margins for captions on mobile exports.

## If `remotion-video-toolkit-1.4.0` is present locally

Load these deep references for advanced work:

- `../remotion-video-toolkit-1.4.0/rules/compositions.md`
- `../remotion-video-toolkit-1.4.0/rules/sequencing.md`
- `../remotion-video-toolkit-1.4.0/rules/transitions.md`
- `../remotion-video-toolkit-1.4.0/rules/text-animations.md`
- `../remotion-video-toolkit-1.4.0/rules/audio.md`
- `../remotion-video-toolkit-1.4.0/rules/rendering.md`
- `../remotion-video-toolkit-1.4.0/rules/transcribe-captions.md`
- `../remotion-video-toolkit-1.4.0/rules/display-captions.md`
