# Creative Guidelines

Use these standards for every production request.

## 1) Narrative first

- Start with one sentence: "Who is this for and what action should they take?"
- Build arc: Hook -> Problem/Desire -> Solution -> Proof -> CTA.
- Keep one dominant message per scene.

## 2) Visual consistency system

- Lock style variables early: color palette, lens style, lighting mood, typography tone.
- Reuse anchor references (product angle, mascot, character wardrobe, set design).
- For iterations, keep seed/references stable and only change one dimension at a time.

## 3) Asset strategy

- Generate a reusable still kit first (hero, alt angle, background, detail close-up).
- Edit/upscale winners before video generation.
- Keep transparent PNG variants for compositing in Remotion.

## 4) Motion strategy

- Use generated AI video for short hero moments (3-8s scenes).
- Use Remotion for deterministic text, transitions, captions, branding, and timing control.
- Avoid overusing camera motion; reserve strong movement for key beats.

## 5) Audio strategy

- Write voiceover lines from storyboard scene goals.
- Keep voiceover intelligibility first (music ducking, clean pauses).
- Target integrated loudness around web/social norms and avoid clipped peaks.

## 6) Product marketing defaults

- Show product in the first 3-5 seconds.
- Demonstrate one core value before listing features.
- Add evidence: metric, testimonial quote, benchmark, or clear visual proof.

## 7) Explainer defaults

- Define the problem in plain language.
- Explain mechanism visually (steps, overlays, animated callouts).
- End with a single next action and expected outcome.

## 8) Revision loop

- Round 1: narrative and pacing approval.
- Round 2: visual style and brand alignment.
- Round 3: polish (caption timing, transitions, audio mix, export settings).

## 9) Delivery checklist

- Correct aspect ratio and safe zones.
- Captions aligned with voiceover.
- No flicker/jumps across scene joins.
- Proper CTA frame hold (at least 2 seconds).

## 10) Reliability

- Keep outputs in predictable folders (`assets`, `scenes`, `audio`, `final`).
- Store storyboard + manifests with each render for reproducibility.
- Log provider/model used for every generated file.
