#!/bin/bash

# Poll for OAuth credential completion
# Usage: ./poll-credential.sh TOKEN [MAX_ATTEMPTS]
#
# Returns:
#   0 - Credential found (outputs JSON to stdout)
#   1 - Timeout waiting for credential
#   2 - Missing token argument

TOKEN=$1
MAX_ATTEMPTS=${2:-24}  # Default: 24 attempts (2 minutes at 5s intervals)

if [ -z "$TOKEN" ]; then
  echo "Error: Missing token argument" >&2
  echo "Usage: $0 TOKEN [MAX_ATTEMPTS]" >&2
  exit 2
fi

for i in $(seq 1 $MAX_ATTEMPTS); do
  # Try to get credential
  RESULT=$(node "$(dirname "$0")/get-credential.js" --token "$TOKEN" 2>/dev/null)
  
  if [ $? -eq 0 ]; then
    # Success! Output credential and exit
    echo "$RESULT"
    exit 0
  fi
  
  # Not found yet, wait before next attempt
  if [ $i -lt $MAX_ATTEMPTS ]; then
    sleep 5
  fi
done

# Timeout
echo "Error: Timeout waiting for credential" >&2
exit 1
