# Share Use Case Skill

Share your OpenClaw use cases to [clawusecase.com](https://clawusecase.com) - a community showcase platform.

## What It Does

When you trigger `/share_usecase` in your OpenClaw chat, your assistant will:

1. **Analyze what you built** - Looks at your recent conversation to understand your project
2. **Draft a use case** - Creates a well-structured submission with title, problem, solution, and tools used
3. **Let you review and edit** - Shows you a preview before submitting
4. **Ask about attribution** - Choose to be credited (via Twitter/GitHub OAuth) or submit anonymously
5. **Publish to the community** - Your use case goes live instantly on clawusecase.com

## Quick Start

Just say:
```
/share_usecase
```

Your assistant handles the rest!

## Examples

**"I just built email notifications for when users subscribe to Pro"**
→ Your assistant drafts a use case about building a Stripe + Resend integration

**"Built a custom dashboard with real-time updates"**
→ Generates a use case about websockets and data visualization

## Attribution Options

When you submit, you can choose:

### ✅ Get Credit
Connect your X (Twitter) or GitHub account to:
- Get a link on the live use case
- Build your profile in the community
- Show off your work

### 🎭 Stay Anonymous
Submit without attribution if you prefer privacy

## How It Works Behind the Scenes

### For Users
1. Trigger `/share_usecase`
2. Review the generated draft
3. Choose attribution or anonymous
4. Done! Your use case is live

### For Developers/Self-Hosters

The skill uses these scripts:

**`submit.js`** - Submits use case to API
```bash
node submit.js \
  --title "Your title" \
  --hook "Short summary" \
  --problem "What problem this solves" \
  --solution "How it works" \
  --category "Development" \
  --skills "GitHub,Stripe,Resend" \
  --requirements "Optional setup notes" \
  --author-username "yourhandle" \
  --author-handle "yourhandle" \
  --author-platform "twitter" \
  --author-link "https://twitter.com/yourhandle"
```

Or anonymous:
```bash
node submit.js ... --anonymous
```

**`get-credential.js`** - Retrieves OAuth credential after auth
```bash
node get-credential.js --token abc123
```

**`normalize-tools.js`** - Normalizes tool/skill names
```bash
node normalize-tools.js "github,stripe api,resend email"
# Output: GitHub, Stripe, Resend
```

## Configuration

Edit `config.json`:
```json
{
  "apiUrl": "clawusecase.com",
  "apiPath": "/api/submissions",
  "convexUrl": "benevolent-tortoise-657.convex.cloud"
}
```

## Categories

- **Productivity** - Task management, scheduling, automation
- **Development** - CI/CD, deployment, testing, code review
- **Business/SaaS** - Customer management, billing, analytics
- **Home Automation** - Smart home, IoT, cameras
- **Social/Content** - Social media, content creation
- **Data & Analytics** - Reports, dashboards, data processing
- **Fun** - Games, experiments, creative projects

## Quality Guidelines

Your use case should:
- **Title**: 20-200 characters, clear and descriptive
- **Hook**: 50-500 characters, attention-grabbing summary
- **Problem**: 100-2000 characters, what issue this solves
- **Solution**: 200-5000 characters, how it works
- **At least 1 skill/tool** used
- **Valid category**

## Rate Limits

- **10 submissions per day** per user
- Helps maintain quality and prevent spam

## Examples of Great Use Cases

### Good 👍
**Title**: "Email notifications for Pro subscriptions"
**Hook**: "Automatically sends welcome emails when users upgrade"
**Problem**: "Users upgrading to Pro weren't receiving confirmation emails, leading to support tickets"
**Solution**: "Built a Resend email integration with React Email templates, connected to Stripe webhooks..."

### Needs Work 👎
**Title**: "Email thing"
**Hook**: "Sends emails"
**Problem**: "No emails"
**Solution**: "Made it work"

## Privacy

- OAuth only accesses your **public profile** (username, display name)
- We **never** post on your behalf or read private data
- Anonymous submissions are completely private

## Support

Issues or questions?
- Check [clawusecase.com](https://clawusecase.com)
- Ask your assistant for help
- Open an issue on the skill repo

## License

MIT - See LICENSE file

---

Built with 🐧 by Rex
