# Shanghai Tech Guide

## Market Snapshot
- Shanghai is a major China tech hub, especially for enterprise tech, fintech, AI applications, and semiconductors.
- Corporate tech and startup tech both exist, but ecosystems differ by district.
- Mandarin is often required for local-facing roles; more flexible in some multinational teams.

## Main Tech Clusters
- Zhangjiang (Pudong): deep tech, chips, biotech, enterprise R&D parks.
- Xuhui West Bund/Caohejing: AI labs, software teams, product organizations.
- Yangpu (near university belt): younger startup teams and digital product work.
- Hongqiao/Changning: regional HQ and multinational digital operations.

## Role Demand (Practical View)
- Stable demand: backend, data engineering, applied AI, cloud ops.
- Growing demand: AI product integration, industrial software, security.
- More cyclical demand: pure growth marketing and non-technical operations.

## Hiring Reality
- Local firms move fast once interviews begin.
- Multinationals usually have slower approval loops.
- Referral quality matters more than cold applications for senior roles.
- Portfolio and shipped outcomes beat generic resume keywords.

## Compensation Pattern
- Base salary varies widely by company tier and role scope.
- Equity in startups can be meaningful but is less liquid than US norms.
- Bonus structures are common in larger local employers.
- Total compensation should include housing and transport reality in Shanghai.

## Work Style Notes
- High-output teams exist in both local and global companies.
- Communication norms differ: concise updates and fast iteration are valued.
- Cross-functional alignment with product and operations is critical.

## Practical Job Search Plan
- Define target: multinational, local giant, or startup.
- Build a Shanghai-relevant project narrative in Mandarin and English if possible.
- Focus on 15-20 target teams rather than mass applying.
- Track interview cycles and decision makers in a simple spreadsheet.

## First 90 Days In A New Role
- Learn internal tools and approval flows quickly.
- Map key stakeholders in engineering, product, and compliance.
- Ship one visible improvement in your first month.
- Build local vendor and partner context, especially for infrastructure choices.
