# Shanghai Startup Guide

## Why Shanghai For Startups
- Access to enterprise customers is strong, especially in manufacturing, retail, logistics, and finance.
- Talent quality is high, with deep pools in product, engineering, and operations.
- Fundraising is possible, but investors expect clear path to revenue.

## Best Startup Zones By Need
- Zhangjiang (Pudong): deep tech, chips, biotech, harder science.
- Xuhui/Caohejing: software and AI product teams.
- Yangpu: cost-aware early teams close to university talent.
- Hongqiao: B2B teams needing regional travel and corporate access.

## What Investors Usually Want To See
- Clear problem tied to real China market demand.
- Early proof of paid pilots, not only user growth.
- Founding team with execution depth in local context.
- Practical regulatory awareness for your sector.

## Founder Execution Priorities
- Month 1-2: lock customer segment and concrete use case.
- Month 3-4: ship paid pilot and document ROI.
- Month 5-6: tighten unit economics and repeatable sales motion.
- Month 7+: scale only after retention and delivery are stable.

## Team Building Reality
- Senior technical hires are competitive and expensive.
- Mid-level operators with industry context can be high leverage.
- Bilingual PM and sales talent is a major advantage.
- Use advisors selectively; operator quality matters more than brand names.

## Common Startup Mistakes In Shanghai
- Building for prestige clients without durable margins.
- Hiring too fast before product-market fit.
- Ignoring compliance until a partner asks for it.
- Expanding districts too early and increasing commute friction.

## Practical Fundraising Approach
- Start with a focused target list of relevant funds.
- Prepare two decks: one strategic narrative, one operating metrics detail.
- Run a tight process window to avoid endless low-signal meetings.
- Keep fallback runway for at least 12 months.

## First-Year Survival Rules
- Keep burn visible weekly.
- Treat enterprise procurement cycles as long by default.
- Build credibility through delivery speed and reliability.
- Choose repeatable channels over one-off PR spikes.
