# Shanghai Safety Guide (2026)

Shanghai is generally considered a low violent-crime city, but daily risk management still matters.
This guide focuses on practical safety and legal awareness.

## Emergency contacts

| Service | Number | Notes |
|---|---|---|
| Police | 110 | Mandarin first; ask hotel/colleague for help if needed |
| Fire | 119 | Provide nearest landmark |
| Ambulance | 120 | Private hospitals may run separate hotlines |
| Traffic accidents | 122 | Use for road incidents |

## Everyday risk profile

| Risk | Typical level | What to do |
|---|---|---|
| Pickpocketing in crowds | Low to moderate | Keep phone and wallet front-side |
| Phone scams/social engineering | Moderate | Verify requests via known contact |
| Bike/scooter collisions | Moderate | Watch turning lanes and silent e-bikes |
| Late-night harassment | Low to moderate | Use licensed ride-hailing and share trip |
| Severe weather disruption | Seasonal | Check alerts during typhoon season |

## Personal safety habits

1. Use official taxis or DiDi with visible plate verification.
2. Avoid unlicensed airport or station rides.
3. Share live trip status with trusted contacts at night.
4. Keep passport copy and visa page in secure cloud storage.
5. Learn your nearest hospital and police station location.

## Apartment and building safety

| Check | Why |
|---|---|
| Door locks and peephole | Basic entry security |
| Fire exits and stair access | High-rise readiness |
| Gas and water shutoff points | Fast response to leaks |
| Compound entry controls | Visitor management |

## Legal caution points

- Drug laws are strict; enforcement can include testing.
- Some online content/tools may be restricted.
- Filming in sensitive sites can trigger police checks.
- Carry valid ID when possible; digital copies are useful but may not always be accepted.

## Health and air quality

On high AQI days, reduce outdoor exercise and use indoor filtration if available.
During heat waves, hydration and shade planning are more important than usual.

## 2026 practical note

Policies and enforcement intensity can shift; verify district-specific guidance when in doubt.
