# Shanghai Healthcare Guide

## System Overview
- Shanghai has both public hospitals and private international clinics.
- Public hospitals are strong for complex care but often crowded.
- Private international care is faster and easier in English, but costly.

## When To Use What
- Minor urgent issues: private clinic or international outpatient center.
- Complex specialist care: top-tier public hospitals, ideally with local help.
- Routine care and prescriptions: neighborhood clinics or trusted private chains.

## Emergency Basics
- Keep your address in Chinese ready for emergency calls.
- If possible, ask a Chinese speaker to assist during urgent intake.
- Bring passport/ID and insurance details when feasible.
- For severe symptoms, prioritize nearest capable hospital over preference.

## Insurance Strategy
- Confirm whether your policy is direct billing or reimbursement.
- Check annual limits, specialist coverage, and emergency transport rules.
- Keep digital and printed copies of your policy card.
- Build a shortlist of in-network clinics near home and work.

## Public Hospital Navigation
- Registration and queueing can be app-based or on-site.
- Specialist appointments may require early booking.
- Bring previous test results to avoid repeat exams.
- Expect shorter consultation time than in many Western systems.

## Medication And Pharmacy
- Major pharmacy chains are common in central districts.
- Bring exact generic names for regular medicines.
- Importing long-term medication can require extra documentation.
- Keep a basic home medical kit for weekends and holidays.

## Family And Preventive Care
- Pick one clinic for annual checks and vaccination tracking.
- For children, identify a pediatric option before you need it.
- Dental and vision care quality is good in major private networks.
- Mental health support exists but provider fit can vary.

## Practical First-Month Checklist
- Register with one international clinic and one backup public hospital.
- Verify insurance claim workflow with a real test appointment.
- Save emergency contacts in both English and Chinese.
- Store translated allergy and chronic condition notes on your phone.
