# Shanghai Education Guide

## Education Landscape
- Shanghai offers international, bilingual, and local school pathways.
- School choice is driven by curriculum goals, commute, and budget.
- Admissions can be competitive, especially for upper grades.

## Main School Types
- International schools: foreign curricula, high fees, strong university counseling.
- Bilingual schools: Chinese + international blend, broad quality range.
- Local schools: strongest Chinese immersion, admission constraints for non-locals.

## Key Decision Factors
- Curriculum fit (IB, British, US, or hybrid).
- Daily commute time for student wellbeing.
- Language trajectory: short-term support vs long-term fluency goals.
- Extracurricular depth for your child's interests.

## District Patterns
- Qingpu and western districts: larger campuses and many international options.
- Xuhui/Jing'an/Changning: central convenience, usually higher pressure on places.
- Pudong: balanced options for families living near business hubs.

## Admissions Reality
- Apply early and prepare for waitlists.
- Schools often request records, references, and student interviews.
- Mid-year transfers are possible but less flexible in top tiers.
- Keep backup options in at least two districts.

## Cost Planning
- Tuition is only part of annual education cost.
- Budget for transport, meals, uniforms, activities, and trips.
- Some schools charge capital or facility fees.
- Confirm refund policy before paying deposits.

## University Pathway Considerations
- Check where recent graduates matriculate, not just marketing claims.
- Ask about counselor caseload and subject availability in upper grades.
- Verify language support for non-native English or Chinese students.

## Practical Parent Checklist
- Shortlist by commute first, then academic brand.
- Visit campuses on normal school days if possible.
- Speak with current parents about workload and communication style.
- Keep a 2-3 year plan in case housing or job location changes.
