# Shanghai Business Setup Guide

## Where Shanghai Fits
- Shanghai is strong for regional HQ functions, high-value services, trade, and advanced manufacturing coordination.
- It offers mature logistics, finance, and legal infrastructure, with higher operating costs than inland cities.

## Legal Structure Options (High Level)
- WFOE: common for full foreign control and local revenue operations.
- Joint Venture: used when local partner access is strategic or required.
- Representative Office: liaison only, no direct revenue activity.
- Hong Kong + mainland structure: common for holding and settlement planning.

## District Selection Matters
- Pudong: finance, advanced industry, and cross-border business support.
- Jing'an/Huangpu: premium offices for client-facing service firms.
- Xuhui/Minhang: mixed tech and operational setups.
- Qingpu/Hongqiao: transport access and regional connectivity.

## Setup Workflow
- Define scope clearly before registration (allowed business activities).
- Secure compliant registered address and documentation.
- Complete entity registration, stamps, tax setup, and bank account.
- Set up payroll, social insurance, and bookkeeping from day one.

## Cost And Timing Reality
- Setup speed depends on business scope and document readiness.
- Office and labor costs in central districts can escalate quickly.
- Compliance is continuous, not a one-time setup item.

## Banking And Finance Operations
- Open at least one primary operational account and one backup option.
- Plan FX flows early if you have cross-border supplier or HQ payments.
- Keep invoice and contract trails clean for tax and audit purposes.

## Hiring And HR Basics
- Written contracts are mandatory and should match practical role scope.
- Social insurance and housing fund obligations apply to eligible employees.
- Employer handbooks and termination process discipline reduce legal risk.

## Common Failure Points
- Registering too broad or too narrow business scope.
- Underestimating monthly compliance workload.
- Delaying finance controls until after first sales.
- Choosing district on rent alone instead of customer and talent proximity.

## Practical Launch Checklist
- Confirm structure, scope, and district in one decision package.
- Engage legal, tax, and payroll providers before incorporation filing.
- Build a 12-month cash plan that includes compliance and hidden admin costs.
- Set governance rules for signing authority and payment approvals.
