# shadcn/ui Component Patterns

Expert guide for building accessible, customizable UI components with shadcn/ui, Radix UI, and Tailwind CSS.

## What's Inside

- Quick start setup for Next.js projects
- Core concepts: `cn` utility, Class Variance Authority (CVA)
- Essential components: Button, Forms, Dialog, Sheet, Card, Toast, Table
- Form validation with React Hook Form + Zod
- Theming with CSS variables in HSL format
- Component customization (you own the code)
- Next.js App Router integration
- CLI reference for component management
- Best practices and accessibility patterns

## When to Use

- Setting up a new project with shadcn/ui
- Installing or configuring individual components
- Building forms with React Hook Form and Zod validation
- Creating accessible UI components (buttons, dialogs, dropdowns, sheets)
- Customizing component styling with Tailwind CSS
- Implementing design systems with shadcn/ui
- Building Next.js applications with TypeScript

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/shadcn-ui
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install shadcn-ui
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/shadcn-ui .cursor/skills/shadcn-ui
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/shadcn-ui ~/.cursor/skills/shadcn-ui
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/shadcn-ui .claude/skills/shadcn-ui
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/shadcn-ui ~/.claude/skills/shadcn-ui
```

## Related Skills

- `tailwind-design-system` — Building component libraries with Tailwind and CVA
- `tailwind-v4-shadcn` — Tailwind v4 setup and migration with shadcn/ui

---

Part of the [Frontend](..) skill category.
