# Visitor Tips & Day Trips — Sevilla

## Essential First-Timer Tips

### Before You Go
1. **Book Alcazar** — 2+ weeks ahead, essential
2. **Check Semana Santa/Feria dates** — Affects everything
3. **Summer = brutal** — Seriously reconsider July-August
4. **Download apps** — TUSSAM (bus), FreeNow (taxi)
5. **Learn basic Spanish** — "Hola", "Gracias", "Una caña por favor"

### On Arrival
1. **Get cash** — Some tapas bars cash-only
2. **Adjust clock mentally** — Lunch 14:00, dinner 21:00+
3. **Siesta is real** — 14:00-17:00 many things close
4. **Book flamenco** — Same day usually OK

### Daily Rhythm
| Time | What's Happening |
|------|------------------|
| 08:00-10:00 | Breakfast, early sights |
| 10:00-14:00 | Main sightseeing |
| 14:00-17:00 | Siesta, lunch, rest |
| 17:00-21:00 | Second sightseeing wave |
| 21:00-00:00 | Tapas, dinner |
| 00:00+ | Nightlife (if inclined) |

---

## Money-Saving Tips

### Free Things
- **Plaza de Espana** — All day
- **Walking Santa Cruz** — Endless
- **Cathedral** — Monday 16:30-18:00
- **Alcazar** — Limited free slots (check schedule)
- **Museo de Bellas Artes** — Free for EU citizens
- **Parks** — All free
- **River walk** — Beautiful, free
- **Markets** — Browsing free, buying cheap

### Budget Hacks
- **Menu del dia** — EUR 10-15 lunch deal
- **Free tapas bars** — Macarena area
- **Supermarket wine** — EUR 3-5 excellent bottles
- **Walking** — No transport costs needed
- **Water fountains** — Refill bottles, safe water
- **Vermouth hour** — Cheaper than evening drinks
- **Morning attractions** — Avoid afternoon heat costs (AC cafes)

### Things That Feel Expensive But Aren't
- **Good jamon** — EUR 8-12 for quality tapa
- **Flamenco** — EUR 20-35 for decent show
- **Sherry** — EUR 2-3 for excellent fino

---

## Tourist Traps

### Avoid

| Trap | Why | Alternative |
|------|-----|-------------|
| Las Ramblas-style restaurants | 3x price, bad food | Walk 2 blocks away |
| Cathedral area restaurants | Tourist menus | Alfalfa, El Rinconcillo |
| Flamenco with dinner | Overpriced, rushed | Show only, eat elsewhere |
| Horse carriage | EUR 50+, not worth it | Walk (better) |
| Tour bus | Limited value | Walking tour or self-guide |
| Airport taxi negotiation | Should be EUR 23 fixed | Use meter or FreeNow |

### How to Spot a Tourist Trap
- Photos of food outside
- "Tourist menu" sign
- Hawkers pulling you in
- Empty at 22:00
- Reviews mentioning "disappointed"

---

## Cultural Notes

### Greetings
- **Two kisses** — Standard greeting (cheeks, not lips)
- **"Hola"** — Start every interaction
- **Eye contact** — More than northern Europe
- **Don't rush** — Pace is slower

### Eating Culture
- **Lunch is main meal** — Often 3 courses
- **Dinner is lighter** — Or just tapas
- **Sharing** — Raciones meant for table
- **Standing at bar** — Totally normal, often cheaper
- **No tipping required** — Round up if excellent

### Social Norms
- **Late everything** — Adjust expectations
- **Loud conversation** — Normal, not rude
- **Physical closeness** — More than Anglo cultures
- **Dress sense** — Smart casual, no gym clothes for dinner

---

## Practical Survival

### Phone/Internet
- **EU roaming** — Works if you have EU SIM
- **Local SIM** — Digi, Lycamobile cheap
- **WiFi** — Hotels, cafes, plazas

### Water
- **Tap water** — Safe to drink
- **Hot tap water in summer** — Let it run first
- **Fountains** — Throughout city, use them

### Toilets
- **Bars** — Buy small drink, use toilet
- **Shopping centers** — Free
- **Museums** — Free with entry
- **Public** — Rare, use bar strategy

### Electricity
- **220V, Type C/F plugs**
- **Adaptor** — UK/US visitors need one

### Language
- **English** — Limited outside tourist core
- **Spanish basics** — Essential
- **Google Translate** — Very helpful
- **Sevillano accent** — Don't worry if you don't understand, they speak fast

---

## Health and Safety

### Heat (Summer)
- **Hydrate constantly**
- **Sunscreen mandatory**
- **Indoor 12:00-18:00**
- **Hat essential**
- **Know heat exhaustion signs**

### Pickpockets
- **Front pocket/crossbody bag**
- **Beware crowds** — Cathedral, metro
- **Terrace bags** — On lap, not chair
- **Phone awareness** — Don't flash it

### Medical
- **Pharmacy (Farmacia)** — For minor issues
- **112** — Emergency number
- **Travel insurance** — Recommended
- **EHIC** — EU citizens bring card

---

## Day Trips

### Close (1 Hour)

| Destination | Transport | Time | Highlights |
|-------------|-----------|------|------------|
| **Italica** | Bus | 30 min | Roman ruins, amphitheater |
| **Carmona** | Bus | 40 min | Historic town, parador |
| **Jerez** | Train | 1h | Sherry bodegas, horses |
| **Cadiz** | Train | 1.5h | Beach, old town, seafood |

### Medium (1.5-2.5 Hours)

| Destination | Transport | Time | Highlights |
|-------------|-----------|------|------------|
| **Cordoba** | Train (AVE) | 45 min | Mezquita (book ahead) |
| **Ronda** | Car/bus | 1.5h | Gorge, white village |
| **Granada** | Train | 2.5h | Alhambra (book months ahead!) |
| **Malaga** | Train | 2h | Picasso, beach |

### Beaches

| Beach | Distance | Notes |
|-------|----------|-------|
| **Matalascanas** | 1h drive | Closest, can be crowded |
| **Mazagon** | 1.5h | Quieter option |
| **Cadiz beaches** | 1.5h train | Worth the trip |
| **Tarifa** | 2h | Wind, kiting, Morocco ferry |

---

## Day Trip Details

### Cordoba (Must-Do)
- **Train**: 45 min AVE, EUR 20-40
- **Mezquita**: Book ahead (not as bad as Alhambra)
- **Jewish Quarter**: Walking around
- **Patios**: May festival, otherwise still pretty
- **Day trip**: Easy, leave morning, back evening

### Ronda (Dramatic)
- **Best by car**: 1.5h, scenic drive
- **Bus**: Longer, less flexible
- **Puente Nuevo**: The famous bridge
- **Combine with**: White villages (Zahara, Grazalema)
- **Day trip**: Full day needed

### Granada (Plan Ahead)
- **Train**: 2.5h, EUR 25-40
- **Alhambra**: Book 2-3 MONTHS ahead
- **Day trip possible**: Tiring but doable
- **Overnight better**: More relaxed
- **Without Alhambra tickets**: Don't go specifically for Granada

### Jerez (Easy Half-Day)
- **Train**: 1h, EUR 15-25
- **Bodega tour**: Book ahead (Tio Pepe, Gonzalez Byass)
- **Sherry tasting**: The point of visiting
- **Horses**: Royal Andalusian School (shows certain days)
- **Combine with**: Cadiz afternoon

### Cadiz (Beach Day)
- **Train**: 1.5h, EUR 15-25
- **Old town**: Beautiful, walkable
- **Beaches**: La Caleta, others
- **Seafood**: Fresh, excellent
- **Full day**: Leave early, return late

---

## Packing Tips

### All Year
- Comfortable walking shoes
- Layers (AC vs outside)
- Sunglasses
- Day bag

### Summer (Essential)
- Lightest clothes possible
- Multiple outfit changes (sweat)
- Hat
- Sunscreen
- Refillable water bottle
- Portable fan

### Winter
- Light jacket
- Sweater
- Normal shoes
- Optional umbrella

### Events
- **Semana Santa**: Dark/respectful clothing
- **Feria**: Flamenco dress (women) or nice clothes

---

## Photography Tips

### Best Light
- **Morning**: 07:30-09:30 (monuments without crowds)
- **Golden hour**: 18:30-20:30 (varies by season)
- **Blue hour**: Just after sunset (Plaza Espana)

### Best Spots
- Plaza de Espana (any time, sunset best)
- Alcazar gardens
- Santa Cruz streets (morning)
- Triana bridge (sunset)
- Setas rooftop (sunset)
- Giralda views from rooftop bars

### Drone
- Illegal in city center
- Legal outside populated areas
- Don't risk it
