# Transport — Sevilla

## Overview

Sevilla is very walkable for a Spanish city. Most attractions are within 30 minutes walking of Centro.

| Mode | Coverage | Best For |
|------|----------|----------|
| **Walking** | Historic center | Primary transport |
| **Bus** | All areas | Main public transit |
| **Metro** | Limited (1 line) | Nervion, Macarena |
| **Bike** | Growing network | Locals, short trips |
| **Tram** | Centro only | Limited use |
| **Taxi/Uber** | Everywhere | Night, heavy bags |

---

## Walking

### Distances from Centro

| To | Time |
|----|------|
| Santa Cruz | 5 min |
| Triana | 10 min |
| Alameda | 10 min |
| Plaza de Espana | 15 min |
| Macarena | 15 min |
| Nervion | 25 min |

**Reality:** Most visitors never need transport within the historic center.

### Pedestrian Zones
- Centro historic core (Sierpes, Constitucion)
- Santa Cruz entirely
- Much of Triana
- Alameda area

---

## Metro

### Line 1 (Only Line)

```
Olivar de Quintos (south) → Ciudad Expo → Condequinto → 
Montequinto → Pablo de Olavide → Cavaleri → Guadaira → 
Blas Infante → Parque de los Principes → Plaza de Cuba → 
San Bernardo → Nervion → Gran Plaza → 1º de Mayo → 
Ronda de Triana → Puerta Jerez → Prado → San Sebastian → 
San Bernardo → Nervion → Gran Plaza → 1º de Mayo
```

### Useful Stops

| Stop | Near |
|------|------|
| **Puerta Jerez** | Cathedral, Centro (closest) |
| **San Bernardo** | Train station (Santa Justa) |
| **Nervion** | Shopping, stadium |
| **Gran Plaza** | Nervion commercial area |

### Tickets

| Type | Price | Notes |
|------|-------|-------|
| Single | EUR 1.35 | One ride |
| Tarjeta Multiviaje | EUR 8.70 (10 trips) | Best value |
| Monthly | EUR 40 | Unlimited |

**Hours:** 06:30-23:00 (til 02:00 weekends)

### Limitations
- Only 1 line
- Doesn't reach Santa Cruz, Triana, Alameda directly
- Better for Nervion/Macarena residents

---

## Bus (TUSSAM)

### Key Lines

| Line | Route | Useful For |
|------|-------|------------|
| **C1/C2** | Circular historic center | Getting around Centro |
| **C3/C4** | Larger circular | Outer neighborhoods |
| **5** | Santa Justa → Centro | Airport connection bus |
| **21** | Centro → Triana | Cross-river |
| **C5** | Night circular | Late night Centro |

### Tickets

| Type | Price |
|------|-------|
| Single (cash) | EUR 1.40 |
| Single (card) | EUR 0.75 |
| Tarjeta Multiviaje | EUR 8.70 (10 trips) |
| Monthly | EUR 40 |

**Tip:** Get a rechargeable card at metro stations or estancos.

### Night Buses
- Lines N1-N8
- Operate Fri/Sat nights til 03:00
- Useful for Alameda nightlife

### App
**TUSSAM app** — Real-time arrivals, route planning.

---

## Tram

Short line through Centro:

```
Plaza Nueva → Archivo de Indias → Puerta Jerez → San Sebastian
```

**Not very useful** — covers area easily walked. Same tickets as bus/metro.

---

## Bike

### Sevici (Public Bikes)

| Type | Price |
|------|-------|
| 7-day pass | EUR 13.33 |
| Annual | EUR 33.33 |
| First 30 min | Free |
| 31-60 min | EUR 1.03 |
| 60+ min | EUR 2.04/hour |

**How it works:**
1. Register at sevici.es or app
2. Pick up bike at any station
3. Return to any station
4. First 30 min free (reset by docking)

**Tip:** Dock every 25 minutes to reset free timer.

### Bike Infrastructure
- Growing network of bike lanes
- Centro largely bikeable
- River paths excellent
- Triana ↔ Centro easy
- Summer: only viable morning/evening

### Private Rental
Many shops around Centro rent bikes EUR 10-15/day.

---

## Taxi

### Fares

| Type | Price |
|------|-------|
| Base fare | EUR 1.50 |
| Per km (day) | EUR 1.10 |
| Per km (night) | EUR 1.34 |
| Airport fixed | EUR 23 |
| Typical Centro-Nervion | EUR 8-10 |

### Apps
- **FreeNow** — Best coverage
- **Uber** — Available but fewer cars
- **Cabify** — Good alternative

### Airport Taxi
Fixed rate EUR 23 from airport to Centro. Don't pay more.

---

## Airport (SVQ)

### Location
10 km northeast of Centro. Small, efficient airport.

### To Centro

| Option | Time | Cost |
|--------|------|------|
| **Taxi** | 20 min | EUR 23 (fixed) |
| **EA Bus** | 35 min | EUR 4 |
| **Uber/Cabify** | 20 min | EUR 18-22 |

**EA Bus:** Every 15-30 min, stops at Santa Justa station and Puerta Jerez.

### From Centro to Airport
- Allow 45 min buffer
- Taxi most reliable
- Book FreeNow ahead

---

## Train (RENFE)

### Santa Justa Station
Main train station, 1.5 km northeast of Centro.

### To Santa Justa from Centro
- Metro: Puerta Jerez → San Bernardo (5 min)
- Bus: Lines 21, 32, C1
- Taxi: EUR 6-8
- Walk: 20-25 min

### Key Routes

| To | Time | Frequency | Price |
|----|------|-----------|-------|
| **Madrid** | 2h 20min (AVE) | Every 30 min | EUR 45-70 |
| **Cordoba** | 45 min (AVE) | Hourly | EUR 15-30 |
| **Malaga** | 2h | Every 2h | EUR 25-45 |
| **Granada** | 2h 30min | 6/day | EUR 25-35 |
| **Cadiz** | 1h 40min | Hourly | EUR 15-25 |

**Book AVE early** for best prices at renfe.com.

---

## Car

### Don't Drive in Centro
- ZBE (Low Emission Zone) restrictions
- No parking
- Narrow streets
- Locals use motorbikes/scooters

### When You Need a Car
- Day trips to villages
- Beach access (Matalascanas)
- Ronda, Sierra Norte

### Rental
- Airport: all major companies
- Centro: Nervion area has some
- Expect EUR 30-50/day

### Parking
- Street: Difficult, expensive, tickets
- Public garages: EUR 15-20/day
- Hotel parking: Often EUR 15-20/day extra

---

## Tips

### For Tourists
1. Walk Centro — no transport needed
2. Get Tarjeta Multiviaje if using bus/metro
3. Sevici good for 3+ days
4. Taxi for airport and heavy bags
5. Download TUSSAM and FreeNow apps

### For Residents
1. Bike or walk for most trips
2. Monthly pass if commuting to Nervion
3. Car only if living in outer areas
4. Motorbike popular option

### Summer Specifics
- Morning transport only
- Buses have AC
- Bikes only early AM or night
- Taxi/Uber for midday
