# Tech Industry — Sevilla

> Sevilla's tech scene is small but growing. Not Madrid or Barcelona level, but increasingly viable.

---

## Overview

| Factor | Status |
|--------|--------|
| **Scene size** | Small-medium |
| **Growth** | Strong, especially since COVID |
| **Remote work** | Common, especially foreign companies |
| **Salaries** | Lower than Madrid/BCN, but so is COL |
| **Talent** | Available, competing with Madrid brain drain |

---

## Companies

### Notable Tech Companies in Sevilla

| Company | What | Notes |
|---------|------|-------|
| **Freepik** | Design resources | HQ in Malaga, office in Sevilla |
| **Aertec** | Aerospace engineering | Growing |
| **Ayesa** | Engineering/consulting | Large local player |
| **NTT Data** | IT consulting | Major office |
| **Emergya** | Digital transformation | Local |
| **Novayre** | Mobility/ticketing | Local startup success |
| **Procengine** | Industrial | Engineering focus |

### Remote-Friendly Companies
Many Sevillanos work remotely for:
- Madrid tech companies
- Barcelona startups
- US/UK companies
- European distributed teams

---

## Salaries (2026)

### Local Companies

| Role | Annual (Gross) | Monthly (Net) |
|------|----------------|---------------|
| Junior Developer | EUR 22,000-28,000 | EUR 1,500-1,900 |
| Mid Developer | EUR 30,000-40,000 | EUR 2,000-2,600 |
| Senior Developer | EUR 42,000-55,000 | EUR 2,700-3,400 |
| Tech Lead | EUR 50,000-65,000 | EUR 3,200-4,000 |
| Engineering Manager | EUR 60,000-80,000 | EUR 3,700-4,800 |

### Remote (Foreign Companies)

| Role | Annual (Gross) | Notes |
|------|----------------|-------|
| Senior Developer | EUR 55,000-80,000 | EU companies |
| Staff/Principal | EUR 80,000-120,000 | US companies |
| Contractor | EUR 80,000-150,000 | Varies wildly |

**Reality:** Remote workers for US/UK companies earn 2-3x local salaries while paying local costs.

---

## Coworking Spaces

| Space | Location | Price | Vibe |
|-------|----------|-------|------|
| **Arenal** | Centro | EUR 180-250/month | Professional |
| **Betacowork** | Alameda | EUR 150-200/month | Startup |
| **The Shed** | Nervion | EUR 150-200/month | Modern |
| **Workincompany** | Various | EUR 120-180/month | Budget |
| **La Noria** | Cartuja | EUR 200/month | Social enterprise |

### Day Passes
Most offer day passes EUR 15-25.

### Cafe Working
Many cafes tolerate laptop workers:
- **Alameda area**: Most tolerant
- **Centro**: Less accepted, more tourist cafes
- **Triana**: Mixed

---

## Tech Hubs

### Cartuja
Former Expo '92 site, now tech/science park:
- Universities
- Research centers
- Some tech companies
- Isolated feeling

### Nervion
- Corporate offices
- NTT Data, larger companies
- Not startup vibe

### Alameda
- Informal tech community
- Coworking spaces
- Networking events
- Startup energy

---

## Community

### Meetups

| Group | What | Frequency |
|-------|------|-----------|
| **Sevilla Tech** | General tech | Monthly |
| **Python Sevilla** | Python | Monthly |
| **WordPress Sevilla** | WP | Monthly |
| **Agile Sur** | Agile/Scrum | Regular |
| **Various JS groups** | Frontend | Sporadic |

### Events
- **SevillaJS** — JavaScript community
- **Various hackatons** — Occasional
- **University events** — Open to public sometimes

### Finding Community
- Meetup.com
- LinkedIn groups
- Coworking space events
- Betabeers Sevilla (startup drinks)

---

## For Job Seekers

### Where to Find Jobs

| Platform | Best For |
|----------|----------|
| **LinkedIn** | All levels |
| **InfoJobs** | Spanish companies |
| **Tecnoempleo** | Tech specific |
| **Glassdoor** | International |
| **Company websites** | Direct applications |
| **Coworking boards** | Startups |

### Visa/Work Considerations

| Situation | What You Need |
|-----------|---------------|
| EU citizen | Nothing, just work |
| Non-EU, hired by Spanish company | Work visa sponsorship |
| Non-EU, remote for foreign company | Digital nomad visa |
| Non-EU, freelance | Autonomo + legal status |

### Digital Nomad Visa (Spain)
Since 2023:
- Non-EU remote workers
- 3+ years experience
- EUR 2,646/month minimum income
- Foreign employer (or own company)
- 1 year, renewable

---

## For Entrepreneurs

### Starting a Company

| Option | What |
|--------|------|
| **Autonomo** | Freelancer status |
| **SL** | Spanish LLC equivalent |
| **Branch office** | If foreign company |

### Autonomo Costs
- Social security: EUR 230-400/month
- Income tax: progressive
- Quarterly declarations
- Accountant: EUR 50-150/month

### Startup Support

| Organization | What |
|--------------|------|
| **Andalucia Emprende** | Government incubation |
| **La Noria** | Social innovation |
| **EOI** | Business school programs |
| **Wayra** | Telefonica accelerator (Madrid mainly) |

---

## Remote Work Culture

### Sevilla as Remote Base

**Pros:**
- Low cost of living
- Good weather 9 months/year
- Lifestyle quality
- Growing expat community
- International airport (limited but improving)

**Cons:**
- Limited direct flights (vs Madrid/Barcelona)
- Smaller tech community
- Fewer in-person networking options
- Summer heat (July-August rough)

### Typical Remote Worker
- Works for Madrid/Barcelona/foreign company
- Lives in Alameda or Triana
- Uses coworking or home office
- Earns EUR 50,000-100,000
- Spends EUR 1,500-2,000/month
- High quality of life

---

## Comparison

| Factor | Sevilla | Madrid | Barcelona |
|--------|---------|--------|-----------|
| **Jobs available** | Few | Many | Many |
| **Salaries** | Lower | High | High |
| **Cost of living** | Low | High | Higher |
| **Quality of life** | High | Medium | High |
| **Networking** | Limited | Excellent | Excellent |
| **Remote work base** | Great | Good | Great |

---

## Advice

### If You're Job Seeking
1. Be open to remote positions
2. Network through coworking spaces
3. Consider Madrid roles with remote options
4. Join local tech meetups
5. LinkedIn is essential

### If You're Remote Working
1. Try Alameda for social scene
2. Get coworking membership for structure
3. Join local tech community anyway
4. Budget for proper home AC
5. Travel during July-August

### If You're Starting a Company
1. Consider Malaga (more startup activity)
2. Use Madrid for fundraising
3. Hire remotely, live in Sevilla
4. Connect with Andalucia Emprende
5. Bootstrap if possible (limited local VC)
