# Student Life — Sevilla

> Sevilla is one of Spain's top university cities, with a massive Erasmus population and excellent student life.

---

## Universities

### Universidad de Sevilla (US)
- Largest in Andalucia
- 65,000+ students
- Multiple campuses across city
- Wide range of programs
- Strong Erasmus presence

**Main Campuses:**
- **Rectorado** (Centro) — Admin, some faculties
- **Reina Mercedes** — Sciences, engineering
- **Cartuja** — Some faculties
- **Pirotecnia** — Various

### Pablo de Olavide (UPO)
- Newer university (1997)
- Outside city (bus/metro access)
- More compact campus
- Strong in social sciences, business
- American campus feel

### Other Institutions
- **EUSA** — Private, communications
- **CEU San Pablo** — Private, various
- **ESIC** — Business school
- **Language schools** — Many

---

## Erasmus Experience

### Why Sevilla is Popular
- #1 or #2 Erasmus destination in Spain
- Weather
- Cost of living
- Party scene
- Spanish + culture immersion
- Friendly locals

### Erasmus Numbers
- 3,000+ incoming Erasmus students/year
- Large international community
- Well-organized programs
- ESN Sevilla active

### Erasmus Life
- Intensive first weeks (orientation, parties)
- International friend groups
- Tapas + cheap drinks culture
- Travel on weekends
- Spanish improves... eventually

---

## Cost of Living

### Monthly Budget

| Category | Range |
|----------|-------|
| **Room (shared flat)** | EUR 300-450 |
| **Food (cooking)** | EUR 150-200 |
| **Eating out** | EUR 100-150 |
| **Transport** | EUR 0-40 |
| **Phone** | EUR 15-20 |
| **Entertainment** | EUR 100-150 |
| **Total** | EUR 665-1,010 |

### Realistic Budgets

| Lifestyle | Monthly |
|-----------|---------|
| **Very tight** | EUR 650-750 |
| **Normal** | EUR 850-1,000 |
| **Comfortable** | EUR 1,100-1,400 |

### Scholarships and Support
- Erasmus grant: ~EUR 300-400/month
- Spanish government: varies
- University scholarships: limited

---

## Housing

### Finding a Room

| Platform | Notes |
|----------|-------|
| **Idealista** | Main platform |
| **Fotocasa** | Second option |
| **Badi** | Room shares |
| **Facebook groups** | "Erasmus Sevilla", "Piso Sevilla" |
| **University boards** | Check uni websites |
| **Word of mouth** | Ask arriving students |

### Best Neighborhoods

| Area | Price | Why |
|------|-------|-----|
| **Macarena** | EUR 280-350 | Cheapest central |
| **Feria/Alameda** | EUR 320-400 | Social, central |
| **Nervion** | EUR 300-380 | Near campus (some) |
| **Triana** | EUR 350-420 | Character, pricier |
| **Centro** | EUR 350-450 | Central but tourist |

### Avoid
- **Santa Cruz** — Too expensive, touristy
- **Far from university** — Transport adds up
- **Scams** — Never pay before seeing

### Tips
1. Visit in person before paying
2. Check contract details
3. Shared flats > residencias (usually)
4. September = peak demand
5. Start searching July-August

---

## Daily Life

### University Cafeterias
- Cheap (EUR 4-6 for menu)
- Quality varies
- Crowded at peak times

### Studying
- University libraries
- Public libraries
- Cafes (Alameda tolerant)
- Home (if quiet)

### Food Shopping
- **Mercadona** — Best value
- **Dia** — Cheapest
- **Lidl** — Good deals
- **Markets** — Fresh produce

### Cooking Reality
- Shared kitchens vary
- Spanish housemates may not cook much
- Learn to make basic tapas
- Pasta is universal student food

---

## Social Life

### Going Out

| Night | What |
|-------|------|
| **Monday** | Dead |
| **Tuesday** | Some activity |
| **Wednesday** | Student night (Erasmus parties) |
| **Thursday** | Buildup to weekend |
| **Friday** | Peak |
| **Saturday** | Peak |
| **Sunday** | Recovery, Alameda afternoon |

### Areas

| Zone | Vibe |
|------|------|
| **Alameda** | Main nightlife, mixed |
| **Alfalfa** | More local, younger |
| **Betis** | Riverside, summer |
| **Feria** | After hours |

### Prices
- **Beer (cana)**: EUR 1.50-2.50
- **Cocktail**: EUR 6-8
- **Club entry**: EUR 5-10 (often free before midnight)
- **Botellon**: EUR 3-5 (supermarket drinks)

### Botellon Culture
Outdoor drinking in plazas/parks:
- Technically illegal but tolerated
- Common pre-going-out activity
- Alameda, river areas
- Cheaper than bars
- Social gathering

---

## Erasmus Network

### ESN Sevilla
- Erasmus Student Network
- Events, trips, support
- Facebook group essential
- Card for discounts

### Events
- Welcome week
- Language exchanges (intercambios)
- Day trips
- Parties
- Cultural activities

### Making Friends
- Other Erasmus (easy, international bubble)
- Spanish students (harder but rewarding)
- Tandem language exchange
- Clubs and activities
- Shared housing

---

## Learning Spanish

### Reality Check
- Many Erasmus students DON'T learn much Spanish
- International bubble is real
- Sevillano accent is challenging
- Effort required to break out

### How to Actually Learn
1. Live with Spanish students
2. Tandem exchanges
3. University courses
4. Force yourself out of comfort zone
5. Apps + Netflix in Spanish

### Language Exchanges
- University organized
- Bar intercambios (Alameda)
- Online apps (Tandem, etc.)
- Library programs

---

## Travel

### From Sevilla

| Destination | How | Time | Cost |
|-------------|-----|------|------|
| **Madrid** | Train (AVE) | 2h 20m | EUR 20-50 |
| **Barcelona** | Train/plane | 5h/1.5h | EUR 40-80 |
| **Lisbon** | Bus | 5h | EUR 20-35 |
| **Morocco** | Ferry from Tarifa | 3h total | EUR 40-60 |
| **Granada** | Train/bus | 2.5h | EUR 15-25 |
| **Malaga** | Train | 2h | EUR 15-30 |

### Budget Travel Tips
- **Blablacar** — Cheap rides
- **Ryanair** — Sevilla airport limited but growing
- **Renfe** — Book early for AVE
- **ALSA buses** — Budget but slow
- **Group trips** — ESN organized

---

## Practical

### Opening a Bank Account
- **N26** or **Revolut** — Easiest, digital
- **Spanish banks** — Need NIE, harder

### Phone
- **Digi** — Cheapest (EUR 10/month unlimited)
- **Lycamobile** — Prepaid, cheap
- **Spanish contracts** — Need NIE

### Health
- **European Health Insurance Card** — For EU students
- **Private insurance** — Non-EU or extra coverage
- **University health services** — Basic

### NIE (Foreigner ID Number)
- Required for many things
- Non-EU: as part of visa
- EU: register at Oficina de Extranjeria
- Takes time, frustrating

---

## Academic Life

### Class Culture
- Less formal than northern Europe
- Attendance varies by professor
- Final exams often weighted heavily
- Group work common
- Spanish language challenges

### Academic Calendar
- Start: September
- End: June
- Exams: January + June
- Breaks: Christmas, Semana Santa

### Passing
- 5/10 minimum to pass
- Curves rare
- Exams can be oral or written
- Group projects common

---

## Advice

### Before Arriving
1. Start searching housing July-August
2. Join Facebook groups
3. Don't expect to be fluent immediately
4. Budget properly
5. Bring documents (NIE, insurance, etc.)

### During Semester
1. Balance Erasmus bubble with local friends
2. Actually go to class
3. Travel but also stay in Sevilla
4. Learn tapas culture
5. Survive summer (if staying)

### Common Mistakes
1. **Only hanging with compatriots** — Defeats purpose
2. **Not learning Spanish** — Regret later
3. **Spending too much first month** — Pace yourself
4. **Missing local culture** — It's not just parties
5. **Terrible housing choice** — Visit before signing
