# Startups and Entrepreneurship — Sevilla

## Ecosystem Overview

| Factor | Status |
|--------|--------|
| **Maturity** | Developing |
| **Funding** | Limited locally |
| **Talent** | Available, growing |
| **Cost** | Low (advantage) |
| **Community** | Small but tight |

### Reality Check
- Not Madrid or Barcelona level
- Fewer VCs, fewer exits
- But: much cheaper, good quality of life
- Growing especially since COVID

---

## Starting a Business

### Legal Structures

| Type | What | Good For |
|------|------|----------|
| **Autónomo** | Self-employed | Freelancers, solo consultants |
| **SL (Sociedad Limitada)** | LLC equivalent | Most startups |
| **SLU** | Single-person SL | Solo founder formal |
| **SA** | Corporation | Larger companies |

### Autónomo

**Requirements:**
- Register with Seguridad Social
- Register with Hacienda (tax authority)
- Monthly social security: EUR 230-400
- Quarterly tax declarations

**Pros:**
- Simple to set up
- Can bill immediately
- Low initial cost

**Cons:**
- Personal liability
- High social security even if not earning
- Less professional perception

### SL (Most Common for Startups)

**Requirements:**
- EUR 3,000 minimum capital
- Notary, registry fees
- Lawyer/gestor recommended
- Bank account

**Costs:**
- Setup: EUR 500-1,500 (with gestor)
- Monthly gestor: EUR 100-200
- Annual accounts filing

**Timeline:** 2-4 weeks with gestor

---

## Getting Help

### Gestorías (Essential)
Administrative agency handling paperwork:
- Company formation
- Tax filings
- Payroll
- Regulatory compliance

**Expect:** EUR 100-200/month for small company

### Lawyers
- Contracts
- Employment law
- IP protection
- Funding documents

**Expect:** EUR 100-300/hour

### Accountants
- Beyond gestor basics
- Financial planning
- Complex tax situations

---

## Workspace

### Coworking Spaces

| Space | Location | Price | Notes |
|-------|----------|-------|-------|
| **Betacowork** | Alameda | EUR 150-200 | Startup-focused |
| **Arenal** | Centro | EUR 180-250 | Professional |
| **The Shed** | Nervion | EUR 150-200 | Modern |
| **Workincompany** | Various | EUR 120-180 | Budget |
| **La Noria** | Cartuja | EUR 200 | Social focus |

### Working from Cafes
- Alameda most tolerant
- Buy drinks regularly
- Morning hours best
- WiFi quality varies

### Office Space
- Cheaper than Madrid/Barcelona (30-40% less)
- Nervion: business district
- Centro: prestige address
- Cartuja: tech park, cheaper

---

## Funding

### Local Options

| Source | Stage | Amount |
|--------|-------|--------|
| **Andalucia Emprende** | Pre-seed | Grants, support |
| **ENISA** | Seed-Series A | EUR 25K-1.5M (loans) |
| **CDTI** | R&D focused | Grants, loans |
| **University programs** | Very early | Small grants |

### National VC

Most Spanish VCs are Madrid-based:
- Kibo Ventures
- JME Ventures
- Samaipata
- Axon Partners

**Strategy:** Build in Sevilla, fundraise in Madrid

### International
- Y Combinator: Remote OK
- European VCs: Accessible
- Angels: Growing network

### Angel Investors
- Growing but small network
- Events/meetups best way to find
- Often ex-entrepreneurs

---

## Support Organizations

### Andalucia Emprende
Government-backed incubation:
- Free workspace (some programs)
- Mentorship
- Workshops
- Regional network

**Website:** andaluciaemprende.es

### La Noria
Social innovation focus:
- Impact startups
- European funding expertise
- Cartuja location

### EOI (Escuela de Organización Industrial)
Business school with startup programs:
- Accelerator programs
- Training
- Network

### University Programs
- Universidad de Sevilla entrepreneurship
- Pablo de Olavide programs
- Technology transfer offices

---

## Community and Events

### Regular Meetups
- **Betabeers Sevilla**: Monthly drinks
- **Startup Grind Sevilla**: Occasional
- **Tech meetups**: Various

### Finding Community
- LinkedIn groups
- Coworking events
- Slack communities
- Andalucia Emprende network

### Annual Events
- **South Summit** (Madrid, but accessible)
- **Local hackathons**: Occasional
- **University events**: Throughout year

---

## Hiring

### Finding Talent

| Platform | Best For |
|----------|----------|
| **LinkedIn** | All roles |
| **InfoJobs** | Spanish talent |
| **Tecnoempleo** | Tech |
| **University job boards** | Junior talent |
| **Coworking word of mouth** | Startup-minded |

### Salary Expectations

| Role | Annual (Gross) |
|------|----------------|
| Junior developer | EUR 22,000-28,000 |
| Mid developer | EUR 28,000-38,000 |
| Senior developer | EUR 38,000-50,000 |
| Junior marketing | EUR 18,000-24,000 |
| Interns | EUR 600-1,000/month |

**Note:** Significantly lower than Madrid. Adjust if competing for talent.

### Employment Types
- **Indefinido**: Permanent (standard)
- **Temporal**: Fixed-term
- **Autónomo dependiente**: Contractor (careful with regulations)

### Social Security
Employer pays ~30% on top of gross salary.
Employee pays ~6.5% from gross.

---

## Taxes

### Corporate Tax (Impuesto de Sociedades)
- 15% first 2 years (new companies)
- 25% standard rate after

### VAT (IVA)
- 21% standard
- 10% reduced (food, hotels)
- 4% super-reduced (basics)
- Quarterly declarations

### Other Considerations
- Payroll taxes
- Modelo 303 (VAT quarterly)
- Modelo 200 (annual corporate)
- **Get a good gestor**

---

## Advantages of Sevilla

### Cost Arbitrage
- Rent: 40% cheaper than Madrid
- Salaries: 20-30% lower
- Lifestyle: cheaper across board
- Quality talent available

### Quality of Life
- Weather
- Food/culture
- Pace of life
- Community feel

### Growing Ecosystem
- More attention post-COVID
- Remote work acceptance
- European funding accessible
- Improving infrastructure

---

## Challenges

### Limited Local Funding
- Most VCs in Madrid
- Less angel network
- Smaller exits = fewer recycled founders

### Brain Drain
- Ambitious talent often moves to Madrid/Barcelona
- Competition for best people

### Network Size
- Smaller community
- Fewer serial entrepreneurs
- Less startup knowledge density

### Infrastructure
- Limited direct international flights
- Sometimes slower bureaucracy
- Less English in government

---

## Strategy for Success

### If Building in Sevilla
1. **Use cost advantage**: Longer runway, lower burn
2. **Remote-first team**: Access national/international talent
3. **Madrid/Barcelona for fundraising**: Travel for investor meetings
4. **International customers**: Don't limit to Andalucia
5. **Build local community**: Small pond, be a big fish

### Model Companies
- **Freepik** (Malaga): Built in Andalucia, global success
- **Various consultancies**: Service businesses work well locally
- **Digital nomad serving**: Leverage foreign purchasing power
