# Safety — Sevilla

> Sevilla is generally very safe. The main concerns are petty theft and summer heat, not violent crime.

## Overall Safety

| Concern | Level | Notes |
|---------|-------|-------|
| **Violent crime** | Very low | Rare, not tourist-targeted |
| **Pickpocketing** | Moderate | Tourist areas, less than Barcelona |
| **Scams** | Low-moderate | Tourist traps more than scams |
| **Night safety** | High | Safe to walk late |
| **Heat danger** | HIGH (summer) | Serious health risk Jul-Aug |

---

## Pickpocketing

### Hot Spots

| Area | Risk Level |
|------|------------|
| Santa Cruz (narrow streets) | Moderate |
| Cathedral queue | Moderate |
| La Giralda area | Moderate |
| Calle Sierpes (crowded) | Moderate |
| Metro/bus (packed) | Moderate |
| Macarena (some areas) | Moderate |
| Feria crowds | Higher |
| Semana Santa crowds | Higher |

### Prevention

1. **Front pocket or cross-body bag**
2. **No backpack in crowds** (or wear it front)
3. **Phone in front pocket, hand on it**
4. **Don't flash valuables**
5. **Beware distraction techniques**
6. **Terrace tables: bag on lap or leg through strap**

### Common Techniques
- **Distraction:** Someone asks question while partner picks
- **Bump:** Crowded area jostle
- **Spill:** "Accidental" drink/ketchup on you
- **Fake petition:** Clipboard distraction
- **Terrace grab:** Bag snatched from chair back

---

## Scams

### Tourist Traps (Not Scams, Just Bad Value)

| Trap | What |
|------|------|
| **Restaurant touts** | Pulling tourists into bad places |
| **Flamenco hawkers** | Selling overpriced shows |
| **Las Ramblas-style restaurants** | 3x price, mediocre |
| **Rose sellers** | Aggressive, overpriced |
| **"Free" anything** | Walking tours with pressure tips |

### Actual Scams (Rare)

| Scam | How |
|------|-----|
| **Rental fraud** | Online listing, pay deposit, no apartment |
| **Fake tickets** | Football/events from unofficial sellers |
| **Card skimming** | Rare, use chip always |
| **Taxi meter off** | Insist on meter |

### Rental Scam Prevention
- Never pay before viewing
- Use known platforms (Idealista, Fotocasa)
- Meet landlord in person
- Check property registration
- Too good to be true = scam

---

## Neighborhood Safety

### Day vs Night

| Area | Day | Night |
|------|-----|-------|
| Santa Cruz | ★★★★★ | ★★★★★ |
| Centro | ★★★★★ | ★★★★★ |
| Triana | ★★★★★ | ★★★★★ |
| Alameda | ★★★★★ | ★★★★☆ |
| Nervion | ★★★★★ | ★★★★★ |
| Los Remedios | ★★★★★ | ★★★★★ |
| Macarena (north) | ★★★★☆ | ★★★☆☆ |
| Poligono Sur | ★★☆☆☆ | ★☆☆☆☆ |
| Tres Mil Viviendas | ★☆☆☆☆ | ★☆☆☆☆ |

### Areas to Avoid

| Area | Why |
|------|-----|
| **Poligono Sur** | High crime, drugs |
| **Tres Mil Viviendas** | Same |
| **Parts of Cerro del Aguila** | Some blocks |
| **Las Vegas (Macarena)** | Rougher area |

**Note:** You won't accidentally wander into these — they're far from tourist areas.

### Late Night Zones

**Safe and active:**
- Alameda (party zone)
- Triana riverfront
- Centro (main streets)
- Feria street

**Quieter but safe:**
- Santa Cruz
- Nervion

---

## Women's Safety

### General Reality
- Street harassment: occasional cat-calling
- Violent risk: very low
- Night walking: generally safe in central areas
- Solo female travelers: common and comfortable

### Recommendations
- Normal city awareness
- Well-lit streets at night
- Group taxi late night if preferred
- Trust instincts as anywhere

---

## LGBTQ+ Safety

### Sevilla
- Generally tolerant
- Not as visible as Madrid/Barcelona
- Alameda area most welcoming
- Pride events (June)
- PDA: same as straight couples (modest public)

### Venues
- Concentrated around Alameda
- Small but active scene
- Mix of bars, not massive clubs

---

## Heat Safety (Serious)

### Summer Danger

Sevilla's heat is a genuine health hazard.

| Temperature | Risk |
|-------------|------|
| 35-38C | Uncomfortable |
| 38-42C | Dangerous without precautions |
| 42-46C | Life-threatening for vulnerable |

### Heat-Related Illness Signs
- Dizziness
- Nausea
- Headache
- Confusion
- Excessive sweating then NO sweating (emergency)

### Prevention
1. **Hydrate constantly** — 3+ liters/day
2. **Avoid 12:00-18:00 outdoors**
3. **Stay in AC during peak heat**
4. **Sunscreen and hat always**
5. **Know your limits**

### Emergency
- Call 112 (EU emergency number)
- Get to shade/AC immediately
- Cool body with wet clothes
- Drink water (slowly if conscious)

---

## Drug Policy

### Cannabis
- Decriminalized for personal use (private)
- Public consumption = fine
- Not openly smoked like Amsterdam
- Don't buy on street

### Other Drugs
- Cocaine, etc: illegal
- Personal use = fine
- Dealing = serious charges

### Clubs/Nightlife
- Drug use exists (like everywhere)
- Not especially open about it
- Standard awareness applies

---

## Alcohol

### Legal
- Drinking age: 18
- No public drinking law (technically illegal but rarely enforced in normal contexts)
- Street drinking (botellon) traditional among youth

### Driving
- Limit: 0.5 mg/ml (0.3 for new drivers)
- Enforcement: checkpoints exist
- Penalties: serious

---

## Emergency Numbers

| Service | Number |
|---------|--------|
| **All emergencies** | 112 |
| **Police (local)** | 092 |
| **Police (national)** | 091 |
| **Ambulance** | 061 |
| **Fire** | 080 |

### Police Stations

| Station | Address | For |
|---------|---------|-----|
| **Policia Nacional** | Avda Blas Infante | Passport/theft reports |
| **Policia Local** | Various | Local issues |

### Lost/Stolen Passport
1. Police report (denuncia) at Policia Nacional
2. Contact embassy
3. Embassy issues emergency travel document

### Embassies/Consulates

| Country | In Sevilla? |
|---------|-------------|
| USA | Madrid (Madrid consulate handles) |
| UK | Madrid (consulate assistance) |
| Australia | Madrid |
| Canada | Madrid |
| Germany | Sevilla consulate exists |
| France | Sevilla consulate exists |

---

## COVID/Health Emergencies

### Current Status (2026)
- No restrictions
- Masks: optional
- Testing: available at pharmacies

### If You Get Sick
- **Farmacia** (pharmacy): for minor issues
- **Centro de salud**: public clinic
- **Hospital**: Virgen del Rocio (largest)
- **Private**: Quironsalud, Vithas

### Travel Insurance
- Recommended for non-EU visitors
- EU citizens: European Health Insurance Card (EHIC)
