# Moving and Settling — Sevilla

## Before You Arrive

### Documents to Prepare
- Passport (valid 6+ months)
- Visa (if non-EU)
- Birth certificate (apostilled for some processes)
- Education certificates (apostilled if working)
- Marriage certificate (if applicable)
- Bank statements
- Employment contract or proof of income

### Visa Categories (Non-EU)

| Visa | For | Duration |
|------|-----|----------|
| **Work visa** | Employed by Spanish company | 1-2 years, renewable |
| **Digital nomad** | Remote workers | 1 year, renewable |
| **Student** | Studying | Duration of studies |
| **Non-lucrative** | Retirees, wealthy | 1 year, renewable |
| **Golden visa** | EUR 500K+ property | 2 years |

### EU Citizens
- No visa needed
- Must register after 3 months
- NIE required for work/banking

---

## First Weeks

### Priority Order

**Week 1:**
1. Find temporary accommodation (Airbnb/hotel)
2. Get SIM card (Digi cheapest)
3. Learn neighborhood basics
4. Open bank account (N26/Revolut easiest)

**Week 2:**
5. Start apartment search
6. Get empadronamiento (if possible with temp address)
7. NIE appointment (book immediately — can take weeks)

**Week 3-4:**
8. Sign lease
9. Empadronamiento with real address
10. Set up utilities (or transfer from landlord)
11. Register with health center

---

## Finding an Apartment

### Where to Search

| Platform | Notes |
|----------|-------|
| **Idealista** | Primary platform |
| **Fotocasa** | Second option |
| **Milanuncios** | Cheaper but riskier |
| **Facebook groups** | Expat shares, rooms |
| **Word of mouth** | Best deals sometimes |

### What to Expect
- **Deposit**: 1-2 months rent
- **Agency fee**: 1 month (if through agency)
- **Contract**: Usually 1 year minimum
- **Furnished**: Standard for foreigners

### Red Flags
- No in-person viewing before payment
- Prices too good to be true
- Pressure to pay quickly
- No proper contract

### Viewing Checklist
- [ ] AC working? (Essential for summer)
- [ ] Water pressure OK?
- [ ] Internet available?
- [ ] Building condition?
- [ ] Noise levels?
- [ ] Natural light?
- [ ] Distance to metro/bus?
- [ ] Neighborhood at night?

### Negotiation
- Rent is sometimes negotiable
- Longer lease = more leverage
- Cash payment sometimes gets discount
- Ask about included utilities

---

## NIE (Foreigner ID Number)

### What It Is
Tax ID number for foreigners. Required for:
- Working
- Banking (Spanish banks)
- Buying property
- Signing contracts
- Many government processes

### How to Get It

**Step 1:** Book appointment
- Website: sede.administracionespublicas.gob.es
- Select: "Policia - Certificados y Asignacion NIE"
- Location: Various police stations
- **Tip:** Check early morning, slots release then

**Step 2:** Gather documents
- Form EX-15 (downloaded, completed)
- Passport + copy
- Photo
- Proof of reason (employment contract, property, etc.)
- Fee payment (Modelo 790, ~EUR 12)

**Step 3:** Attend appointment
- Arrive early
- Expect bureaucracy
- May receive immediately or collect later

### Frustration Warning
- Appointments can be weeks out
- Website often has no slots
- Some people try multiple offices
- Gestors can help (for a fee)

---

## Empadronamiento (Registration)

### What It Is
Registration of your address with local government.

### Why You Need It
- Healthcare access
- Some discounts
- Voting (EU citizens)
- Proof of residence
- Required for many processes

### How to Get It
1. Go to Registro Civil for your district
2. Bring: ID, rental contract, utility bill (or landlord's)
3. Fill form
4. Receive certificate immediately

### Tips
- Some landlords reluctant (tax implications)
- Temporary addresses sometimes accepted
- Renewal needed if you move

---

## Healthcare

### Public System (Seguridad Social)

**Who's Eligible:**
- Employees (through work)
- Self-employed (autonomos)
- EU citizens (with EHIC or registration)
- Legal residents

**How to Register:**
1. Get social security number (if working)
2. Go to Centro de Salud in your area
3. Bring NIE, empadronamiento, Seguridad Social card
4. Get assigned doctor

**What You Get:**
- GP (médico de cabecera)
- Specialists (with referral)
- Hospital care
- Prescriptions (subsidized)

### Private Insurance

| Provider | Monthly | Notes |
|----------|---------|-------|
| **Sanitas** | EUR 40-80 | Major player |
| **Adeslas** | EUR 40-80 | Major player |
| **DKV** | EUR 50-90 | Good coverage |
| **Cigna** | EUR 60-120 | International |

**Why Private:**
- Faster specialist access
- English-speaking doctors
- Some employers provide

---

## Banking

### Digital Banks (Easiest)
- **N26**: EU residents, free basic
- **Revolut**: Easy signup, multi-currency
- **Wise**: Good for transfers

### Spanish Banks (For Direct Debits)
- **Santander**: Largest network
- **BBVA**: Good app
- **CaixaBank**: Regional giant
- **ING**: No fees, online-first

### Requirements for Spanish Banks
- NIE
- Proof of address
- Passport
- Some income proof

---

## Phone and Internet

### Mobile
- **Digi**: Cheapest (EUR 10/unlimited)
- **Lycamobile**: Prepaid, cheap
- **Movistar/Vodafone/Orange**: Expensive but reliable

### Home Internet
- **Digi**: EUR 30, 1Gbps (best value)
- **Movistar**: EUR 45+, reliable
- **Orange/Vodafone**: Similar to Movistar

### Getting Connected
- NIE needed for contracts
- Prepaid: passport only
- Installation: 1-2 weeks

---

## Work

### If Employed by Spanish Company
- Company handles most paperwork
- Contract required before work visa
- Seguridad Social through employer
- Tax withheld automatically

### If Self-Employed (Autónomo)
1. Get NIE
2. Register with Hacienda (tax)
3. Register with Seguridad Social
4. Start paying monthly (~EUR 300)
5. Quarterly tax declarations

### If Remote for Foreign Company
- Digital nomad visa (if non-EU)
- Autónomo registration required
- Tax situation complex — get advice
- EUR 2,646/month minimum for DNV

---

## Taxes

### Income Tax (IRPF)
Progressive rates: 19% to 47%
- Withheld from salary if employed
- Declared annually (April-June)

### Beckham Law
- Special tax regime for new residents
- 24% flat rate (instead of progressive)
- 5-year limit
- Specific requirements

### Tax Residency
- 183+ days = Spanish tax resident
- Worldwide income taxed
- Get professional advice

---

## Daily Life Setup

### Utilities
- Electricity: Iberdrola, Endesa
- Gas: Naturgy
- Water: EMASESA (municipal)
- Often transfer from landlord

### Grocery
- Mercadona: best value
- Carrefour: large selection
- Dia/Lidl: budget

### Transport
- Tarjeta Multiviaje: rechargeable bus/metro
- Sevici: bike share (annual EUR 33)

---

## Social Integration

### Language
- Spanish essential
- Sevillano accent challenging
- Classes: CLIC, Universidad de Sevilla, private tutors
- Language exchanges: bars, apps

### Meeting People
- Coworking spaces
- Sports clubs
- Language exchanges
- Expat groups (InterNations, Facebook)
- Hobby groups

### Cultural Adjustment
- Expect late schedule
- Siesta is real
- Bureaucracy slow
- Relationships matter
- Embrace the pace

---

## Checklist Summary

### Month 1
- [ ] NIE application started
- [ ] Empadronamiento done
- [ ] Bank account opened
- [ ] Phone/internet setup
- [ ] Apartment signed
- [ ] Healthcare registered

### Month 2-3
- [ ] NIE received
- [ ] Utilities in your name
- [ ] Routine established
- [ ] Spanish classes started
- [ ] Social connections forming

### First Year
- [ ] Tax declaration filed
- [ ] Fiestas experienced (Feria, Semana Santa)
- [ ] Summer survived
- [ ] Community built
- [ ] Spanish improving
