# Choosing a Neighborhood — Sevilla

## Quick Decision Tree

```
┌─ Visiting short-term (1-2 weeks)?
│  └─ Yes → Santa Cruz, Centro, or Triana
│  └─ No (moving/long-term) ↓
│
├─ Priority is budget?
│  └─ Yes → Macarena or outer Nervion
│  └─ No ↓
│
├─ Priority is authenticity?
│  └─ Yes → Triana or Alameda
│  └─ No ↓
│
├─ Priority is nightlife?
│  └─ Yes → Alameda
│  └─ No ↓
│
├─ Priority is family/safety?
│  └─ Yes → Nervion or Los Remedios
│  └─ No ↓
│
├─ Priority is beauty/charm?
│  └─ Yes → Santa Cruz or Triana
│  └─ No ↓
│
└─ Default → Centro (balance of everything)
```

---

## By Profile

### Tourist (Short Stay)

| Priority | Best Choice |
|----------|-------------|
| Romance/beauty | Santa Cruz |
| Authentic tapas | Triana |
| Balance | Centro |
| Budget | Macarena |
| Nightlife access | Alameda |

### Young Professional

| Priority | Best Choice |
|----------|-------------|
| Social/nightlife | Alameda |
| Food scene | Triana |
| Central/convenient | Centro |
| Budget | Macarena, Feria |
| Modern amenities | Nervion |

### Family

| Priority | Best Choice |
|----------|-------------|
| Safety + schools | Nervion |
| Quieter | Los Remedios |
| Traditional feel | Triana |
| Budget | Macarena (careful block) |

### Student

| Priority | Best Choice |
|----------|-------------|
| Cheapest | Macarena |
| Near university | Macarena, San Bernardo |
| Social | Alameda |
| Balance | Feria |

### Remote Worker

| Priority | Best Choice |
|----------|-------------|
| Cafes + coworking | Alameda |
| Charming | Triana |
| Central | Centro |
| Budget | Feria, Macarena |

### Digital Nomad

| Priority | Best Choice |
|----------|-------------|
| Social + networking | Alameda |
| Authentic + food | Triana |
| Short-term pretty | Santa Cruz |
| Value | Feria |

### Retiree

| Priority | Best Choice |
|----------|-------------|
| Beautiful + quiet | Santa Cruz |
| Community | Triana |
| Practical | Nervion |
| Safe + calm | Los Remedios |

---

## Comparison Table

| Neighborhood | Rent 1BR | Safety | Character | Nightlife | Transit | Food |
|--------------|----------|--------|-----------|-----------|---------|------|
| Santa Cruz | EUR 900-1,200 | ★★★★★ | Historic | ★☆☆☆☆ | Bus | Tourist |
| Centro | EUR 750-1,000 | ★★★★★ | Mixed | ★★★☆☆ | Tram/Bus | Mixed |
| Alameda | EUR 700-950 | ★★★★☆ | Hip | ★★★★★ | Bus | Great |
| Triana | EUR 650-900 | ★★★★★ | Authentic | ★★★☆☆ | Bus | Best |
| Feria | EUR 550-750 | ★★★★☆ | Local | ★★★☆☆ | Bus | Authentic |
| Macarena | EUR 500-700 | ★★★☆☆ | Working | ★★☆☆☆ | Metro | Free tapas |
| Nervion | EUR 550-800 | ★★★★★ | Modern | ★☆☆☆☆ | Metro | Chain |
| Los Remedios | EUR 650-850 | ★★★★★ | Residential | ★☆☆☆☆ | Bus | Local |
| San Bernardo | EUR 500-750 | ★★★★☆ | Practical | ★☆☆☆☆ | Metro/Train | Basic |

---

## Trade-offs

### Beauty vs Budget
- **Beautiful + expensive**: Santa Cruz
- **Beautiful + reasonable**: Triana
- **Cheap + ugly**: Macarena
- **Balance**: Alameda, Centro

### Central vs Quiet
- **Central + lively**: Centro, Alameda
- **Central + quiet**: Santa Cruz
- **Quiet + far**: Los Remedios, Nervion
- **Balance**: Triana

### Tourist vs Local
- **Full tourist**: Santa Cruz
- **Tourist-local mix**: Centro
- **Local with some tourists**: Triana
- **Pure local**: Macarena, Nervion, Los Remedios

---

## Common Mistakes

### Tourist Mistakes
1. **Booking Santa Cruz for 2+ weeks** — Gets boring, overpriced
2. **Staying in Nervion** — No reason unless specific purpose
3. **Ignoring Triana** — Many skip it, they're wrong

### Resident Mistakes
1. **Macarena without visiting first** — Some blocks rough
2. **Santa Cruz long-term** — Beautiful but soulless
3. **Far from work** — Traffic and heat make commutes painful

### Budget Mistakes
1. **Cheapest available** — Usually a reason it's cheap
2. **No AC in summer** — False economy
3. **Ground floor Centro** — Noise issues

---

## Questions to Ask Yourself

### Before Deciding
1. How long am I staying?
2. Do I need to work from here?
3. Do I speak Spanish?
4. What's my actual budget?
5. Do I have kids?
6. Do I want nightlife?
7. Do I need car/parking?

### Visiting an Apartment
1. Does AC work? (Check in summer)
2. What floor? (Ground = noise)
3. Neighbors above/below?
4. Closest supermarket?
5. Can I see it at night?

---

## Month-by-Month Considerations

### Summer (Jun-Sep)
- **AC is non-negotiable**
- Avoid top floors (heat rises)
- Cross-ventilation important
- River proximity nice for walks

### Winter (Nov-Feb)
- Heating less critical (mild)
- Natural light valuable
- Any neighborhood works

### Semana Santa / Feria
- **Santa Cruz**: Crowded, loud, expensive
- **Centro**: Same
- **Los Remedios**: Chaos during Feria
- **Triana**: Active but manageable
- **Macarena**: Business as usual

---

## Final Recommendations

### If I Had to Choose One...

**For tourists:** Triana
- Authentic, beautiful, great food, safe
- Walking distance to monuments
- Not overpriced

**For expats/residents:** Alameda
- Young, social, good value
- Central but not touristy
- Nightlife and cafes
- Coworking friendly

**For families:** Nervion
- Safe, schools, practical
- Not exciting but reliable
- Modern amenities

**For students:** Macarena (near metro)
- Cheapest central option
- Metro access
- University proximity
- Free tapas tradition

**For romantics:** Santa Cruz
- If money no object
- Short-term only
- Pure beauty
