# Local Services — Sevilla

## Banking

### Opening an Account

**For EU Citizens:**
- NIE required (foreigner ID)
- Passport
- Proof of address (utility bill, rental contract)
- Some banks accept hotel confirmation short-term

**For Non-EU:**
- Same as above
- Valid visa/residence permit
- May be harder at some branches

### Major Banks

| Bank | Notes |
|------|-------|
| **Santander** | Largest, good network |
| **BBVA** | Major, good app |
| **CaixaBank** | Regional but large |
| **ING** | Online, no fees |
| **N26/Revolut** | Digital, easy signup, EU only |

### Digital Options
- **N26**: German neobank, free basic account
- **Revolut**: Multi-currency, easy
- **Wise**: Good for transfers

### Recommendation
**N26 or Revolut** for digital nomads/short stays.
**Santander/BBVA** for long-term residents (needed for direct debits).

---

## Phone and Internet

### Mobile Providers

| Provider | Notes | Price |
|----------|-------|-------|
| **Digi** | Cheapest, good coverage | EUR 10/month unlimited |
| **Lycamobile** | Prepaid, cheap | EUR 10-15/month |
| **Pepephone** | Budget, Orange network | EUR 15-20/month |
| **Movistar** | Main carrier, expensive | EUR 30+/month |
| **Vodafone** | Main carrier | EUR 25+/month |
| **Orange** | Main carrier | EUR 25+/month |

### Getting a SIM
- **Prepaid**: Any phone shop, passport required
- **Contract**: NIE required
- **Tourist SIM**: Airport, not great value

### Home Internet

| Provider | Speed | Price |
|----------|-------|-------|
| **Digi** | 1Gbps | EUR 30/month |
| **Movistar** | Various | EUR 40-60/month |
| **Vodafone** | Various | EUR 40-55/month |
| **Orange** | Various | EUR 35-50/month |

**Best value**: Digi (if available in building)
**Most reliable**: Movistar

### Installation
- Takes 1-2 weeks typically
- Technician visit required
- Some buildings pre-wired

---

## Healthcare

### Public System (Seguridad Social)

**Who's Covered:**
- Employees (through work contributions)
- Self-employed (autonomos)
- EU citizens (EHIC card)
- Residents (through registration)

**Quality**: Good, but wait times for specialists

### Getting Care

| Need | Where |
|------|-------|
| Minor issues | Centro de Salud (assigned by address) |
| Pharmacy | Any Farmacia |
| Urgent (not emergency) | Urgencias in Centro de Salud |
| Emergency | Hospital Urgencias |

### Private Healthcare

| Provider | Notes |
|----------|-------|
| **Sanitas** | Major insurer |
| **Adeslas** | Major insurer |
| **Cigna** | International |
| **DKV** | Good coverage |

**Costs**: EUR 40-120/month depending on coverage and age

### Pharmacies (Farmacias)
- Green cross sign
- Can advise on minor issues
- Some medications OTC that require prescription elsewhere
- 24h pharmacies exist (rotating)

### Emergency
- **112**: All emergencies
- **061**: Medical emergency
- **Hospital Virgen del Rocio**: Largest hospital

---

## Government and Bureaucracy

### NIE (Foreigner ID Number)

**What it is**: Tax/ID number for foreigners
**Who needs it**: Anyone working, banking, signing contracts

**How to get it:**
1. Book appointment (Sede Electronica)
2. Go to Oficina de Extranjeria
3. Bring: passport, form EX-15, proof of reason
4. Pay fee (around EUR 12)
5. Receive certificate

**Reality**: Frustrating, prepare for multiple attempts

### Empadronamiento (Registration)

**What**: Registering your address with local government
**Why**: Required for many services, voting, some discounts

**How**:
1. Go to your district Registro Civil
2. Bring: passport/ID, rental contract, utility bill
3. Fill form
4. Receive certificate

### Appointments (Cita Previa)

Most government services require prior appointment:
- **sede.administracion.gob.es**: National services
- **Local websites**: Municipal services
- **Call centers**: Alternative but slow

**Tips**:
- Check early morning (new slots released)
- Try different offices
- Spanish language usually required

---

## Mail and Packages

### Correos (National Post)
- Yellow signs
- Reasonable for national
- Slow for international
- Post office locations throughout city

### Package Delivery
| Carrier | Notes |
|---------|-------|
| **Amazon** | Usually reliable |
| **SEUR** | National carrier |
| **MRW** | Common |
| **GLS** | European |
| **DHL** | International |

### Receiving Packages
- Building porters (porteros) help
- Neighbor delivery common
- Pickup points (Amazon lockers, Correos)
- Some buildings have lockers

---

## Housing Practicalities

### Utilities Setup

| Utility | Main Providers |
|---------|----------------|
| **Electricity** | Iberdrola, Endesa, Naturgy |
| **Gas** | Naturgy, Endesa |
| **Water** | EMASESA (municipal) |

### Changing Name on Bills
- NIE required
- Visit provider office or online
- May need deposit
- Landlord should help with transfer

### Garbage
- Street bins (containers)
- Recycling: yellow (plastic), blue (paper), green (glass)
- Organic: brown (some areas)
- Collection: evening/night usually

### Building Communities
- **Comunidad de vecinos**: Building association
- Monthly fees for common areas
- Meetings for decisions
- President elected among owners

---

## Transportation Cards

### Bus/Metro
- **Tarjeta Multiviaje**: Rechargeable card
- Buy at: metro stations, estancos (tobacco shops)
- Recharge at: metro machines, estancos
- Monthly pass: EUR 40

### Sevici (Bikes)
- Annual: EUR 33
- Register: sevici.es
- App: Sevici for station availability

---

## Shopping

### Supermarkets

| Store | Vibe |
|-------|------|
| **Mercadona** | Best value, everywhere |
| **Carrefour** | Large selection |
| **Dia** | Cheapest basics |
| **Lidl** | Good deals, limited selection |
| **El Corte Ingles** | Upscale, expensive |

### Markets
- **Mercado de Triana**: Fresh food, tapas
- **Mercado de Feria**: Local
- **Mercado del Arenal**: Tourist-local mix

### Opening Hours
- **Supermarkets**: 09:00-21:30 (most)
- **Small shops**: 10:00-14:00, 17:00-20:30
- **Sundays**: Most closed except Mercadona/Carrefour

---

## Services

### Laundry
- **Launderettes**: Rare, exist in some areas
- **Dry cleaners (Tintorerias)**: Throughout city
- **Home machines**: Standard in apartments

### Hair/Beauty
- **Peluquerias**: Everywhere
- Prices: EUR 15-30 for basic cut
- Walk-in usually possible

### Gyms

| Type | Price |
|------|-------|
| **Basic chains** | EUR 25-35/month |
| **Mid-range** | EUR 40-60/month |
| **Premium** | EUR 80+/month |
| **Municipal pools** | EUR 30-50/month |

Popular: Altafit, McFit, O2 Centro Wellness

---

## Language

### Learning Spanish

| Option | Notes |
|--------|-------|
| **CLIC** | Private school, good reputation |
| **Universidad de Sevilla** | Official courses |
| **Instituto Cervantes** | Official exams |
| **Private tutors** | EUR 15-30/hour |
| **Language exchanges** | Free, bars, apps |

### Sevillano Accent
- S's disappear ("Sevilla" sounds like "Seviya")
- Fast pace
- Distinctive vocabulary
- Don't worry if you don't understand initially

---

## Expat Resources

### Online Communities
- **Facebook groups**: "Expats in Seville", "Americans in Seville"
- **Internations**: Events, networking
- **Meetup**: Various groups

### English Services
- **English-speaking doctors**: Private clinics
- **International schools**: For families
- **Expat accountants**: For tax help

### Consulates
- **US**: Madrid (handles Seville)
- **UK**: Madrid/Malaga
- **Germany**: Seville office
- **France**: Seville office

---

## Tips for New Residents

### First Month
1. Get NIE (start process immediately)
2. Get empadronamiento
3. Get SIM card
4. Open bank account
5. Learn neighborhood
6. Find your supermarket
7. Locate pharmacy and health center

### First Year
1. Build routine
2. Learn Spanish (seriously)
3. Make local friends
4. Understand fiestas calendar
5. Survive first summer
6. File taxes correctly
