# Practical Food Guide — Sevilla

## Dining Schedule

### Spanish Timing (Adjust Expectations)

| Meal | Time | Notes |
|------|------|-------|
| **Breakfast** | 08:00-10:30 | Coffee + tostada |
| **Mid-morning** | 11:00-12:00 | Optional coffee |
| **Aperitivo** | 12:30-14:00 | Pre-lunch tapas |
| **Lunch** | 14:00-16:00 | Main meal |
| **Merienda** | 18:00-19:00 | Coffee/snack |
| **Tapas** | 20:30-23:00 | Evening eating |
| **Dinner** | 21:30-23:30 | If eating properly |

### What This Means
- **19:00 dinner** = tourist restaurant
- **20:30 tapas** = starting to get local
- **22:00 restaurant** = normal
- **Empty at 21:00** = probably bad

---

## Dietary Needs

### Vegetarian

**Challenges:**
- Ham is in EVERYTHING
- "Vegetarian" may still have fish
- Stock often meat-based
- Limited dedicated options

**Safe Choices:**
- Gazpacho / Salmorejo (usually veg)
- Tortilla espanola
- Espinacas con garbanzos (ASK — sometimes has ham)
- Pimientos de padron
- Patatas bravas
- Ensaladas (salads)
- Queso (cheese)
- Pan con tomate

**How to Communicate:**
- "Soy vegetariano/a" (I'm vegetarian)
- "¿Esto tiene carne o jamón?" (Does this have meat or ham?)
- "Sin jamón, por favor" (Without ham, please)

**Vegetarian-Friendly Restaurants:**
- Alameda area has most options
- Look for "opciones vegetarianas" signs
- Indian/Middle Eastern restaurants

### Vegan

**Much harder than vegetarian.**

**Challenges:**
- Dairy in many dishes
- Eggs everywhere (tortilla, etc.)
- Fewer dedicated options

**Safe Choices:**
- Gazpacho (usually vegan)
- Grilled vegetables (verduras a la plancha)
- Olives
- Pan con tomate (verify no butter)
- Ensaladas (no cheese, check dressing)

**Vegan Restaurants:**
- Growing in Alameda
- Search "restaurante vegano sevilla"
- Not many, but they exist

### Gluten-Free

**Better Than Expected:**

**Naturally GF:**
- Most tapas (not breaded)
- Meats, fish
- Cheese, jamon
- Tortilla
- Gazpacho, salmorejo

**Watch Out:**
- Fried items (batter may have flour)
- Cross-contamination
- Bread served with everything

**How to Communicate:**
- "Soy celiaco/a" (I have celiac)
- "¿Tiene gluten?" (Does it have gluten?)
- "Sin gluten" is understood

### Allergies

**Communication:**
- "Soy alérgico/a a..." (I'm allergic to...)
- Nuts = frutos secos
- Shellfish = mariscos
- Dairy = lácteos
- Eggs = huevos

**Be Specific:**
Spanish speakers may not automatically think of cross-contamination. Be clear.

### Halal

**Options:**
- Macarena has immigrant communities with halal options
- Some Middle Eastern restaurants
- Seafood is always halal
- Ask "¿Es halal?" if uncertain

### Kosher

**Very Limited:**
- No dedicated kosher restaurants in Sevilla
- Self-catering recommended
- Some supermarkets have kosher sections

---

## Alcohol Guide

### Beer

| Type | What |
|------|------|
| **Caña** | Small beer (20cl) — standard order |
| **Tubo** | Taller glass |
| **Jarra** | Half liter |
| **Cerveza sin alcohol** | Non-alcoholic (common, good quality) |

**Local Brands:**
- **Cruzcampo** — Sevillian, most common
- **Alhambra** — Granadan, popular
- **Mahou** — Madrid, everywhere

### Wine

| Type | What |
|------|------|
| **Tinto** | Red wine |
| **Blanco** | White wine |
| **Rosado** | Rosé |
| **Tinto de verano** | Red wine + lemon soda (summer essential) |

**House wine** (vino de la casa) is usually fine and cheap.

### Sherry

Jerez (Sherry) is 30 minutes away. This is THE local drink.

| Type | Taste |
|------|-------|
| **Fino** | Dry, crisp, cold |
| **Manzanilla** | Like fino, from Sanlúcar |
| **Amontillado** | Darker, nuttier |
| **Oloroso** | Rich, dark |
| **Pedro Ximénez (PX)** | Sweet, dessert |

**Must-try:** Fino or Manzanilla with tapas. Cold, from barrel if possible.

### Other Drinks

| Drink | What |
|-------|------|
| **Rebujito** | Fino + 7UP (Feria drink) |
| **Clara** | Beer + lemon soda |
| **Vermut** | Vermouth, pre-meal |
| **Café con hielo** | Espresso + glass of ice |
| **Agua con gas** | Sparkling water |

---

## Tipping

### The Rule
**Not expected. Round up if excellent.**

### In Practice
- **Tapas bars**: Leave coins, maybe EUR 0.50-1
- **Restaurants**: Round up 5-10% if great
- **Coffee**: Leave change
- **Tour guides**: EUR 5-10 if group tour

### Don't
- Feel guilty not tipping
- Tip like Americans (15-20%)
- Hand tip to server (leave on table/bar)

---

## Reservations

### When Needed
- **Eslava**: Recommended
- **Weekend dinners**: Popular places
- **Semana Santa/Feria**: Essential
- **Groups (5+)**: Always helpful

### When Not Needed
- **Tapas bars**: Almost never
- **Weekday lunches**: Usually fine
- **Standing at bar**: Never

### How to Book
- Phone (Spanish helpful)
- Google Maps "Reserve a table"
- TripAdvisor
- Walk in and ask

---

## Payment

### Cash vs Card
- **Cards**: Most places now accept
- **Cash**: Some traditional bars prefer
- **Small bars**: May be cash-only
- **Markets**: Often cash-only

### How to Pay
- "La cuenta, por favor" (The bill, please)
- Bill brought to table
- Pay at register or table (varies)
- No check splitting typically (pay together, settle outside)

---

## Ramadan

### Context
Growing Muslim population. Ramadan affects:
- Some halal restaurants adjust hours
- Macarena area more visible
- Fasting locals appreciated

### For Tourists
- No restrictions on non-Muslims
- Normal restaurant operation
- Be respectful if among fasting people

---

## Water

### Tap Water
- Safe to drink in Sevilla
- Can taste chlorinated
- Restaurants may push bottled

### At Restaurants
- "Agua del grifo" (tap water) — free, may get looks
- "Agua mineral" (bottled) — usual order
- "Con gas" / "Sin gas" — sparkling/still

### Summer
- Hydrate constantly
- 3+ liters per day
- Public fountains exist, safe

---

## Coffee Culture

### Types

| Coffee | What |
|--------|------|
| **Café solo** | Espresso |
| **Cortado** | Espresso + splash of milk |
| **Café con leche** | Coffee with milk (50/50) |
| **Café con hielo** | Espresso + separate glass of ice |
| **Descafeinado** | Decaf |

### How to Order
1. "Un café..." followed by type
2. "Con leche" is most common
3. "Para llevar" if takeaway (rare)

### Where
- Any bar
- Dedicated cafes (less common than bars)
- Morning: any bar with "desayuno" signs

### Price
- EUR 1.20-2.50 depending on place
- Standing at bar often cheaper

---

## Bread

### At Restaurants
- Often charged (EUR 0.50-1.50)
- Comes automatically
- Can decline: "Sin pan, gracias"

### Quality
- Industrial bread common
- Better restaurants have better bread
- Pa amb tomàquet style common

---

## Menu Vocabulary

| Spanish | English |
|---------|---------|
| **Carta** | Menu |
| **Menu del día** | Fixed lunch menu |
| **Entrantes** | Starters |
| **Principales** | Mains |
| **Postres** | Desserts |
| **Casero/a** | Homemade |
| **Del día** | Of the day |
| **A la plancha** | Grilled |
| **Frito/a** | Fried |
| **Al horno** | Baked |
| **Crudo/a** | Raw |
| **Guiso** | Stew |
