# Food Culture — Sevilla

## The Tapeo: Core Social Ritual

**Tapeo** = hopping from bar to bar, eating small plates, standing, socializing.

This is not dining. It's a social ritual:
- 1-2 tapas per bar, then move
- Standing at the bar or on the street
- Often free tapa with each drink
- Conversation is half the experience
- Same bars, same faces, daily routine for locals

### Timing

| Meal | Time | What |
|------|------|------|
| Desayuno | 08:00-10:00 | Coffee + tostada (toast with tomato/oil) |
| Cervecita | 12:00-14:00 | Pre-lunch tapas + beer |
| Almuerzo | 14:00-16:00 | Main meal (or extended tapeo) |
| Merienda | 18:00-19:00 | Coffee/snack |
| Tapas | 20:30-23:00 | Evening tapeo |
| Cena | 22:00-00:00 | If eating proper dinner |

**Key insight:** Sevillanos don't eat dinner at restaurants the way tourists do. They do tapeo instead.

### Free Tapas Culture

Many bars give a free tapa with each drink. This is dying in tourist areas but alive in local bars.

**Where free tapas still exist:**
- Macarena neighborhood (most bars)
- Parts of Triana
- Working-class areas
- NOT: Santa Cruz, tourist Centro

**How it works:**
1. Order a cana (small beer) or wine
2. Bartender brings a small tapa automatically
3. Second drink = different tapa
4. No choosing, just accept what comes

### Vocabulary

| Term | Meaning | Serving Size |
|------|---------|--------------|
| **Tapa** | Small plate | 1-2 bites, often free |
| **Media racion** | Half portion | Good for 1-2 people |
| **Racion** | Full portion | Sharing plate for 2-4 |
| **Cana** | Small beer (20cl) | Standard order |
| **Tubo** | Tall beer | Bigger but less common |
| **Tinto de verano** | Red wine + lemon soda | Summer essential |
| **Rebujito** | Fino sherry + 7UP | Feria drink |
| **Montadito** | Small sandwich/toast | Common tapa format |

## Price Guide

| Item | Tourist Area | Local Bar |
|------|--------------|-----------|
| Cana (beer) | EUR 2.50-3.50 | EUR 1.50-2.00 |
| Tapa | EUR 3.00-5.00 | Often free or EUR 2.00 |
| Media racion | EUR 6.00-10.00 | EUR 4.00-7.00 |
| Racion | EUR 10.00-18.00 | EUR 7.00-12.00 |
| Menu del dia | EUR 12.00-18.00 | EUR 10.00-13.00 |

**Budget tapeo:** EUR 15-20 for full evening (local bars, free tapas)
**Tourist tapeo:** EUR 35-50 (paid tapas, tourist areas)

## Menu del Dia (Weekday Lunch)

The Spanish lunch special. Usually weekdays only, 13:00-16:00.

**Typical format:**
- Starter (2-3 options)
- Main (2-3 options)
- Dessert or coffee
- Bread + drink included
- EUR 10-15 at local places

**Best value meal in Spain.** Look for "Menu del dia" signs.

## Dining Culture Notes

### Where to Sit
- **Barra (bar)**: Standing, fastest service, most authentic
- **Mesa (table)**: More expensive, slower, fine for groups
- **Terraza (terrace)**: Premium price (10-20% more), nice weather

### Ordering Style
- Order drink first, tapas come after
- No rush — meal can last hours
- Bread often charged (EUR 0.50-1.00)
- No tipping required (round up if excellent)
- Ask for "la cuenta" to get the bill

### Restaurant Quality Signals
- **Crowded 22:00** = good sign
- **Empty 22:00** = tourist trap
- **Chalkboard specials** = fresh
- **Photos on menu** = avoid
- **Near major monuments** = probably bad

## Best Food Areas

| Area | Known For | Price Level |
|------|-----------|-------------|
| Triana | Authentic tapas, flamenco bars | EUR EUR |
| Alameda | Hip, diverse, international | EUR EUR EUR |
| Feria | Traditional, free tapas | EUR |
| Santa Cruz | Tourist, pretty, overpriced | EUR EUR EUR EUR |
| Centro | Mixed, depends on bar | EUR EUR EUR |
| Macarena | Cheap, local, free tapas | EUR |
| Nervion | Mall food, chains | EUR EUR |

See `food-tapas.md` for specific bar recommendations.

## Dietary Considerations

### Vegetarian
- Challenging but doable
- Safe choices: gazpacho, salmorejo, tortilla, espinacas con garbanzos
- Say "soy vegetariano/a" clearly
- Watch for ham in "everything"

### Vegan
- Difficult. Most things have jamon or dairy.
- Look for specifically vegan restaurants (Alameda area has some)
- Markets are your friend

### Gluten-Free
- Improving but still limited
- "Sin gluten" is understood
- Many traditional dishes are naturally GF
- Cross-contamination is common — be specific

### Halal
- Growing options in Macarena (immigrant community)
- Otherwise difficult
- Seafood is safe option

### Kosher
- Very limited
- Self-catering recommended

## Seasonal Eating

| Season | What's Good |
|--------|-------------|
| Spring | Gazpacho appears, Feria food |
| Summer | Cold soups (gazpacho, salmorejo), seafood |
| Autumn | Mushrooms, game meats |
| Winter | Stews (cocido), heavier dishes |
| Year-round | Jamon, pescaito frito, tortilla |

## Where NOT to Eat

| Avoid | Why |
|-------|-----|
| Restaurants on Calle Sierpes | Tourist markup |
| Plaza Nueva terraces | 3x price for view |
| Anywhere with laminated photo menus | Tourist trap signal |
| Beachfront Matalascanas restaurants | Overpriced, mediocre |
| Fast food in tourist zones | Same price as real tapas |

**Rule:** Walk 2 blocks from any major attraction. Quality up, prices down.
