# Flamenco — Sevilla

> Sevilla is flamenco's spiritual home. But most tourists see mediocre shows.

## Understanding Flamenco

### What It Is
- Art form: singing (cante), guitar (toque), dance (baile)
- Emotional expression, often pain, longing, joy
- Andalusian origin, Roma (gitano) roots
- UNESCO Intangible Cultural Heritage

### Key Elements

| Element | Role |
|---------|------|
| **Cante** (singing) | Core of flamenco, most important |
| **Toque** (guitar) | Accompaniment, virtuosic |
| **Baile** (dance) | What tourists focus on |
| **Palmas** (clapping) | Complex rhythmic patterns |
| **Jaleo** (shouts) | Encouragement: "Ole!", "Eso es!" |

### Styles (Palos)

| Palo | Character |
|------|-----------|
| **Soleares** | Deep, serious, foundational |
| **Alegrias** | Happy, from Cadiz |
| **Bulerias** | Fast, festive, party vibe |
| **Siguiriyas** | Dark, intense, tragedy |
| **Tangos** | Upbeat, accessible |
| **Fandangos** | Varied, regional styles |

---

## Tourist Shows (Tablaos)

### What to Expect
- Scheduled show (1-1.5 hours)
- Professional dancers
- Set routines
- Drink included
- EUR 25-45 per person
- Often dinner option (EUR 60-80)

### Recommended Tablaos

| Venue | Location | Price | Notes |
|-------|----------|-------|-------|
| **La Casa del Flamenco** | Santa Cruz | EUR 25 | Intimate, good quality |
| **Museo del Baile Flamenco** | Centro | EUR 25-30 | Good venue, context |
| **Los Gallos** | Santa Cruz | EUR 35 | Historic, established |
| **Casa de la Memoria** | Centro | EUR 22 | Small, authentic feel |
| **El Arenal** | Centro | EUR 40 | Dinner show option |

### Tourist Show Warnings
- Dinner shows often mediocre food at high price
- Large group venues = worse intimacy
- Earlier shows (19:00) less energetic
- Book direct, not through hotels (markup)

---

## Authentic Flamenco (Peñas and Bars)

### The Real Experience
- Spontaneous or semi-organized
- Local audience
- Raw emotion over polish
- Late night (after midnight)
- Often in bars, not theaters
- Difficult to access as tourist

### Where to Find Real Flamenco

**Triana (flamenco's heart):**

| Venue | Type | Notes |
|-------|------|-------|
| **La Carboneria** | Bar | Free entry, tourist-accessible authentic |
| **Casa Anselma** | Bar | After midnight, no cameras, real |
| **Lola de los Reyes** | Bar | Late night, local crowd |
| **T de Triana** | Bar | Modern flamenco scene |

**Alameda:**

| Venue | Type | Notes |
|-------|------|-------|
| **Casa Latina** | Bar | Free shows sometimes |
| **Fun Club** | Club | Late night flamenco |

### Tips for Authentic Venues

1. **Go late** — Real flamenco starts after midnight
2. **Don't photograph** — Turn off camera, live the moment
3. **Be quiet** — Never talk during performance
4. **Show appreciation** — "Ole!" at right moments (follow locals)
5. **Don't request songs** — Let it flow naturally
6. **Buy drinks** — Support the venue
7. **Be patient** — May wait 1-2 hours for spontaneous cante

---

## Free/Budget Flamenco

| Option | Details |
|--------|---------|
| **Street performers** | Plaza de Espana, Santa Cruz (variable quality) |
| **La Carboneria** | Free entry bar, tips to artists |
| **Local fiestas** | Feria, Velada Santa Ana |
| **YouTube deep dive** | Watch Camaron, Paco de Lucia, etc. |

---

## Flamenco Calendar

| Event | When | What |
|-------|------|------|
| **Bienal de Flamenco** | Sep (even years) | World's top flamenco festival |
| **Feria de Abril** | April | Sevillanas dancing everywhere |
| **Semana Santa** | Easter | Saetas (improvised flamenco singing) |
| **Noche de San Juan** | June 23 | Beach celebrations, some flamenco |

### Bienal de Flamenco
Every 2 years (2024, 2026...), September:
- 3 weeks of shows
- World's best artists
- Theater and street performances
- Book months ahead
- bienal-flamenco.org

---

## Learning Flamenco

### Dance Classes

| School | Location | Notes |
|--------|----------|-------|
| **Museo del Baile Flamenco** | Centro | Tourist-friendly intro classes |
| **Fundacion Cristina Heeren** | Centro | Serious students, multi-week |
| **Taller Flamenco** | Centro | Various levels |
| **Academia Manuela Carrasco** | Triana | Traditional |

### What to Expect
- Drop-in classes: EUR 15-25
- Weekly: EUR 60-100/month
- Intensive: EUR 200-500/week
- Footwear: proper shoes needed

---

## Flamenco Fashion

### Traditional Elements

| Item | What |
|------|------|
| **Bata de cola** | Long-trained dress for dance |
| **Mantón** | Embroidered shawl |
| **Peineta** | High comb |
| **Flores** | Flowers in hair |
| **Zapatos** | Flamenco shoes (nailed heels) |

### Where to Buy

| Shop | Location | What |
|------|----------|------|
| **El Rocio** | Centro | Complete outfits |
| **Taller de Diseño** | Various | Custom dresses |
| **Maty** | Centro | Shoes, accessories |
| **Mercado** | Various | Shawls, fans |

---

## Flamenco vs Sevillanas

| Flamenco | Sevillanas |
|----------|------------|
| Art form, complex | Social dance, structured |
| Solo or small group | Pairs |
| Improvised | 4 set parts (coplas) |
| Years to master | Learn basics in weeks |
| Any time | Mainly Feria |

**Sevillanas** is what you see at Feria — everyone dancing. Easier to learn, great entry point.

### Learning Sevillanas
- Many academies offer short courses
- Feria prep classes start March
- 4-8 classes to learn basics
- Social and fun

---

## Quick Recommendations

### First Timer
1. Start with tablao show (La Casa del Flamenco)
2. Watch documentary "Flamenco Flamenco" (Carlos Saura)
3. Late night at La Carboneria
4. Feria if timing works

### Serious Enthusiast
1. Bienal de Flamenco (even years)
2. Peña flamenca membership
3. Week of classes
4. Triana bars after midnight

### Budget
1. La Carboneria (free)
2. Street performances
3. Watch/listen to recordings
4. Local fiestas
