# Weather and Climate — Sevilla

> Sevilla has the hottest summers of any major European city. This is not an exaggeration.

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain Days | Verdict |
|-------|----------|---------|-----------|---------|
| January | 16C | 6C | 6 | Mild, occasional rain |
| February | 18C | 7C | 5 | Warming up |
| March | 21C | 9C | 5 | ★★★★★ Perfect |
| April | 23C | 11C | 6 | ★★★★★ Excellent |
| May | 27C | 14C | 3 | ★★★★★ Warm but great |
| June | 33C | 18C | 1 | Getting hot |
| July | 36C | 20C | 0 | ★☆☆☆☆ Brutal |
| August | 36C | 20C | 0 | ★☆☆☆☆ Peak brutal |
| September | 32C | 19C | 2 | Still very hot |
| October | 26C | 15C | 6 | ★★★★★ Recovery |
| November | 20C | 10C | 6 | ★★★★☆ Pleasant |
| December | 16C | 7C | 7 | Mild, Christmas vibe |

## The Summer Reality

**July-August facts:**
- Regular highs of 40-45C (104-113F)
- Heat starts at 10:00, unbearable by 14:00
- Evening relief only after 21:00
- Some days don't drop below 30C at night
- 2023 saw 12 consecutive days above 40C

**What this means:**
- Outdoor sightseeing: 08:00-11:00 only
- Siesta is survival, not laziness
- AC is mandatory, not luxury
- Locals leave the city if they can
- Tourist numbers drop significantly

## Surviving Summer

### Daily Schedule
```
07:00-11:00 — Outdoor activities (before it gets deadly)
11:00-14:00 — Museums, indoor attractions
14:00-18:00 — Siesta, AC, pool, rest
18:00-21:00 — Still hot but survivable
21:00+      — Life resumes, terraces open
```

### Survival Essentials
- **Hydration**: 3+ liters water/day minimum
- **Sunscreen**: Factor 50, reapply constantly
- **Hat**: Non-negotiable
- **Light clothing**: Linen, cotton, light colors
- **AC verification**: Before booking any accommodation
- **Portable fan**: Many locals carry small ones
- **Cold drinks**: Ice coffee (cafe con hielo) culture

### Where to Escape Heat
- **Museums**: All air-conditioned (CAAC, Bellas Artes, Alcazar)
- **Shopping centers**: Nervion Plaza, Torre Sevilla
- **Rooftop pools**: Hotel pool day passes
- **River**: Paddle boats on Guadalquivir
- **Day trips**: Beach (Matalascanas 1h), mountains (Sierra Norte)

## Best Times to Visit

| Priority | Best Period | Why |
|----------|-------------|-----|
| 1st | Late March - Early May | Perfect weather, Semana Santa, Feria |
| 2nd | October - Early November | Warm but comfortable, fewer tourists |
| 3rd | February - Early March | Mild, cheap, authentic |
| Avoid | July - August | Unless you love suffering |

## Seasonal Events Impact

| Event | When | Weather | Crowds |
|-------|------|---------|--------|
| Semana Santa | Easter week | Usually perfect (20-25C) | Extreme |
| Feria de Abril | 2 weeks after Easter | Warm (22-28C) | Extreme |
| Summer | Jul-Aug | Hell | Low (smart people leave) |
| Christmas | Dec | Mild (15-18C) | Moderate |

## Rain Patterns

- Rain is infrequent but intense when it comes
- Winter months (Nov-Feb) see most rainfall
- Summer is essentially rainless (June-September)
- Flash floods can happen in autumn
- Umbrella useful Oct-Mar, unnecessary Apr-Sep

## What to Pack

### Spring/Autumn (Best seasons)
- Light layers
- One warm layer for evenings
- Comfortable walking shoes
- Sunglasses, light hat
- Small umbrella (just in case)

### Summer (Survival mode)
- Lightest clothes possible
- Multiple changes (you will sweat)
- Good sunscreen
- Hat (essential)
- Refillable water bottle
- Portable fan
- Sunglasses

### Winter
- Light jacket
- Sweater
- Normal shoes (rarely wet)
- Maybe an umbrella
- No heavy winter gear needed

## Comparison with Other Cities

| City | Summer High | Winter Low | Annual Rain Days |
|------|-------------|------------|------------------|
| Sevilla | 36C | 6C | 50 |
| Madrid | 32C | 2C | 60 |
| Barcelona | 28C | 6C | 55 |
| Malaga | 30C | 8C | 45 |

Sevilla is significantly hotter than all other major Spanish cities in summer.
