# SEV-SNP Attestation Report Fields

This document describes the fields in an AMD SEV-SNP attestation report.

## Report Structure Overview

The attestation report is a 1184-byte (0x4A0) binary structure signed by the AMD Platform Security Processor (PSP). The signature covers bytes 0x00-0x29F (672 bytes).

## Key Fields

### VERSION (offset 0x00, 4 bytes)

Report format version. Currently version 2 for SEV-SNP.

```
Value: 0x02000000 (little-endian) = version 2
```

### GUEST_SVN (offset 0x04, 4 bytes)

Guest Security Version Number. Set by the hypervisor, represents the guest's security version.

### POLICY (offset 0x08, 8 bytes)

Guest policy flags controlling VM behavior:

| Bit | Name | Description |
|-----|------|-------------|
| 0 | SMT | Allow SMT (hyperthreading) |
| 1 | Reserved | - |
| 2 | MIGRATE_MA | Allow migration via Migration Agent |
| 3 | DEBUG | Debug mode (attestation should fail if set) |
| 4-15 | Reserved | - |
| 16-19 | ABI_MAJOR | Minimum ABI major version |
| 20-27 | ABI_MINOR | Minimum ABI minor version |

**Security Note**: If bit 3 (DEBUG) is set, the VM is in debug mode and should NOT be trusted with secrets.

### FAMILY_ID (offset 0x10, 16 bytes)

Family ID set by the guest owner. Can be used to group related VMs.

### IMAGE_ID (offset 0x20, 16 bytes)

Image ID set by the guest owner. Identifies the specific VM image.

### VMPL (offset 0x30, 4 bytes)

Virtual Machine Privilege Level (0-3) at which the report was generated.

- VMPL 0: Most privileged (firmware)
- VMPL 1-3: Less privileged (OS, applications)

### SIGNATURE_ALGO (offset 0x34, 4 bytes)

Signature algorithm used. Value 1 = ECDSA P-384 with SHA-384.

### TCB_VERSION (offset 0x38, 8 bytes)

Trusted Computing Base version, containing component versions:

| Offset | Size | Component |
|--------|------|-----------|
| 0x00 | 1 | Boot Loader SPL |
| 0x01 | 1 | TEE SPL |
| 0x02-0x05 | 4 | Reserved |
| 0x06 | 1 | SNP SPL |
| 0x07 | 1 | Microcode SPL |

SPL = Security Patch Level

### PLATFORM_INFO (offset 0x40, 8 bytes)

Platform configuration information:

| Bit | Name | Description |
|-----|------|-------------|
| 0 | SMT_EN | SMT enabled on platform |
| 1 | TSME_EN | Transparent SME enabled |

### AUTHOR_KEY_EN (offset 0x48, 4 bytes)

Whether an author key was used for the MEASUREMENT digest.

### REPORT_DATA (offset 0x50, 64 bytes)

**Critical field**: Guest-provided data included in the report.

Used for:
- Freshness nonce (prevent replay attacks)
- Hash of public key for key binding
- Application-specific data

The verifier should check that REPORT_DATA matches the expected nonce/challenge.

### MEASUREMENT (offset 0x90, 48 bytes)

**Critical field**: SHA-384 hash of the initial guest memory contents.

This is the cryptographic measurement of:
- Guest firmware
- Initial kernel/initrd (if launch-measured)
- Initial memory state

Compare against known-good measurements to verify guest integrity.

### HOST_DATA (offset 0xC0, 32 bytes)

Data provided by the hypervisor. Can be used for hypervisor identification.

### ID_KEY_DIGEST (offset 0xE0, 48 bytes)

SHA-384 digest of the ID public key, if AUTHOR_KEY_EN is set.

### AUTHOR_KEY_DIGEST (offset 0x110, 48 bytes)

SHA-384 digest of the Author public key, if AUTHOR_KEY_EN is set.

### REPORT_ID (offset 0x140, 32 bytes)

Unique report identifier for this report instance.

### REPORT_ID_MA (offset 0x160, 32 bytes)

Report ID of the Migration Agent, if migration is allowed.

### REPORTED_TCB (offset 0x180, 8 bytes)

TCB version reported to the guest (may differ from actual TCB_VERSION).

### CHIP_ID (offset 0x1A0, 64 bytes)

**Critical field**: Unique identifier for the AMD chip.

Used to:
- Fetch the chip-specific VCEK certificate
- Verify the report came from a specific physical processor

### COMMITTED_TCB (offset 0x1E0, 8 bytes)

Committed TCB version that matches the VCEK certificate.

### CURRENT_BUILD (offset 0x1E8, 1 byte)

Current firmware build number.

### CURRENT_MINOR (offset 0x1E9, 1 byte)

Current firmware minor version.

### CURRENT_MAJOR (offset 0x1EA, 1 byte)

Current firmware major version.

### COMMITTED_BUILD (offset 0x1EB, 1 byte)

Committed firmware build number.

### COMMITTED_MINOR (offset 0x1EC, 1 byte)

Committed firmware minor version.

### COMMITTED_MAJOR (offset 0x1ED, 1 byte)

Committed firmware major version.

### LAUNCH_TCB (offset 0x1F0, 8 bytes)

TCB version at VM launch time.

### SIGNATURE (offset 0x2A0, 144 bytes)

ECDSA P-384 signature over bytes 0x00-0x29F.

Format: R (72 bytes, little-endian) || S (72 bytes, little-endian)

The signature is verified using the VCEK public key.

## Verification Checklist

When verifying an attestation report, check:

1. **VERSION**: Is it a supported version?
2. **POLICY.DEBUG**: Is debug mode disabled (bit 3 = 0)?
3. **REPORT_DATA**: Does it match your challenge/nonce?
4. **MEASUREMENT**: Does it match expected known-good value?
5. **SIGNATURE**: Is it valid using the VCEK certificate?
6. **TCB_VERSION**: Is it at acceptable security patch level?

## References

- [AMD SEV-SNP ABI Specification](https://www.amd.com/system/files/TechDocs/56860.pdf)
- [AMD SEV Secure Nested Paging Firmware ABI Specification](https://developer.amd.com/sev/)
