---
name: sev-attestation
description: Perform AMD SEV-SNP remote attestation to cryptographically verify VM identity and integrity. Use when proving a VM is running in a genuine AMD SEV-SNP confidential computing environment, verifying VM integrity before trusting it with secrets, checking SEV-SNP availability, generating attestation reports, validating AMD certificate chains (ARK/ASK/VCEK), or debugging attestation failures.
---

# sev-attestation

AMD SEV-SNP remote attestation for cryptographic VM identity verification.

## Description

Perform AMD SEV-SNP (Secure Encrypted Virtualization - Secure Nested Paging) remote attestation to cryptographically verify VM identity and integrity. Use this skill when:

- Proving a VM is running in a genuine AMD SEV-SNP confidential computing environment
- Verifying the integrity of a confidential VM before trusting it with secrets
- Checking if SEV-SNP is available and properly configured
- Generating attestation reports for remote verification
- Validating AMD certificate chains (ARK → ASK → VCEK)
- Debugging attestation failures or certificate issues

**Keywords**: SEV-SNP, attestation, confidential computing, AMD, VCEK, certificate chain, remote attestation, VM identity, TCB, measurement

## Workflow

```
┌─────────────────────────────────────────────────────────────────┐
│                    SEV-SNP Attestation Flow                      │
└─────────────────────────────────────────────────────────────────┘
                              │
                              ▼
                    ┌─────────────────┐
                    │  1. Detection    │
                    │  Is SEV-SNP      │
                    │  available?      │
                    └────────┬────────┘
                             │
              ┌──────────────┴──────────────┐
              │                             │
              ▼                             ▼
        ┌─────────┐                   ┌─────────┐
        │   YES   │                   │   NO    │
        └────┬────┘                   └────┬────┘
             │                              │
             ▼                              ▼
    ┌─────────────────┐             ┌─────────────────┐
    │ 2. Generate     │             │ Exit with       │
    │    Report       │             │ helpful error   │
    └────────┬────────┘             └─────────────────┘
             │
             ▼
    ┌─────────────────┐
    │ 3. Display      │
    │    Report Info  │
    └────────┬────────┘
             │
             ▼
    ┌─────────────────┐
    │ 4. Fetch AMD    │
    │    Certificates │
    │ (ARK, ASK, VCEK)│
    └────────┬────────┘
             │
             ▼
    ┌─────────────────┐
    │ 5. Verify       │
    │    Cert Chain   │
    └────────┬────────┘
             │
             ▼
    ┌─────────────────┐
    │ 6. Verify       │
    │    Report Sig   │
    └────────┬────────┘
             │
             ▼
    ┌─────────────────┐
    │   PASSED or     │
    │   FAILED        │
    └─────────────────┘
```

## Quick Start

### Check if SEV-SNP is Available

```bash
./scripts/detect-sev-snp.sh
```

### Run Full Attestation

```bash
./scripts/full-attestation.sh [output_dir]
```

This runs the complete 6-step attestation workflow and outputs PASSED or FAILED.

## Individual Steps

Each step can be run independently for debugging or custom workflows:

| Script | Purpose |
|--------|---------|
| `scripts/detect-sev-snp.sh` | Check SEV-SNP availability |
| `scripts/generate-report.sh <output_dir>` | Generate attestation report with nonce |
| `scripts/fetch-certificates.sh <report_file> <output_dir>` | Fetch AMD certificates from KDS |
| `scripts/verify-chain.sh <certs_dir>` | Verify certificate chain |
| `scripts/verify-report.sh <report_file> <certs_dir>` | Verify report signature |

## Prerequisites

- **snpguest**: Rust CLI from [virtee/snpguest](https://github.com/virtee/snpguest)
- **openssl**: For certificate operations
- **curl**: For fetching certificates from AMD KDS
- **Root access**: Required to access `/dev/sev-guest`

Install snpguest:
```bash
cargo install snpguest
```

## Reference Documentation

- [Report Fields](references/report-fields.md) - Attestation report field reference
- [Error Codes](references/error-codes.md) - Common errors and troubleshooting
- [Manual Verification](references/manual-verification.md) - OpenSSL-based verification without snpguest

## Technical Details

- **AMD KDS URL**: `https://kdsintf.amd.com`
- **Certificate Chain**: ARK (self-signed) → ASK → VCEK
- **Report Signature**: ECDSA P-384
- **Device**: `/dev/sev-guest` (requires root or sev group membership)
