# SEV-SNP 远程证明工具

AMD SEV-SNP 远程证明，用于验证虚拟机身份和完整性。

## 快速开始

```bash
# 检测 SEV-SNP 是否可用
./scripts/detect-sev-snp.sh

# 运行完整证明流程
./scripts/full-attestation.sh ./output
```

## 脚本说明

| 脚本 | 功能 |
|------|------|
| `detect-sev-snp.sh` | 检测 SEV-SNP 可用性 |
| `generate-report.sh` | 生成证明报告 |
| `fetch-certificates.sh` | 从 AMD 获取证书 |
| `verify-chain.sh` | 验证证书链 |
| `verify-report.sh` | 验证报告签名 |
| `full-attestation.sh` | 完整证明流程 |

## 依赖

- snpguest (`cargo install snpguest`)
- openssl
- curl
- root 权限

## 参考文档

- `references/report-fields.md` - 报告字段说明
- `references/error-codes.md` - 错误排查
- `references/manual-verification.md` - 手动验证方法
