---
name: setup-local-testnet
description: >-
  Spin up a local Anvil testnet with Uniswap deployed and pre-seeded liquidity.
  One command gives you a full development environment with funded accounts,
  real Uniswap pools, and zero gas costs. Use when developing, testing, or
  demoing Uniswap agent workflows.
model: sonnet
allowed-tools:
  - mcp__uniswap__setup_local_testnet
  - mcp__uniswap__fund_test_account
  - mcp__uniswap__get_supported_chains
---

# Setup Local Testnet

## Overview

Spins up a local Anvil testnet forking a live chain with all Uniswap contracts available, pre-funded test accounts, and real pool state. This is the foundation for all local testing -- every other testnet skill depends on it.

**Why this is 10x better than doing it manually:**

1. **One command**: Instead of writing 30+ lines of shell script to start Anvil, impersonate whales, fund accounts, and verify contracts, you say "set up a local testnet" and it's done.
2. **Pre-funded accounts**: Each test account gets 10,000 ETH plus 1M USDC, 1M USDT, 10K DAI, 100 WETH, and 10K UNI -- ready for any testing scenario.
3. **Real pool state**: Fork mode gives you every Uniswap pool with real liquidity, real prices, and real tick state. No mocking required.
4. **Contract discovery**: Returns all relevant Uniswap contract addresses (V3Factory, NonfungiblePositionManager, UniversalRouter, Permit2, QuoterV2) so you can immediately interact with them.
5. **Port management**: Automatically finds an available port, handles conflicts, and cleans up previous testnets.
6. **Follow-up integration**: Output is designed to feed directly into `create-test-pool` and `time-travel` skills.

## When to Use

Activate when the user says anything like:

- "Set up a local testnet"
- "Start a local Anvil fork"
- "I need a test environment for Uniswap"
- "Fork Ethereum locally"
- "Set up a dev environment"
- "I want to test without spending real gas"
- "Spin up Anvil with Uniswap"
- "Create a test environment for my agent"

**Do NOT use** when the user already has a testnet running and just wants to add pools (use `create-test-pool`) or advance time (use `time-travel`).

## Parameters

| Parameter      | Required | Default    | How to Extract                                                        |
| -------------- | -------- | ---------- | --------------------------------------------------------------------- |
| mode           | No       | fork       | "fork" or "mock" -- fork is the default and recommended               |
| forkFrom       | No       | ethereum   | "ethereum", "base", "arbitrum", "optimism", "polygon"                 |
| blockNumber    | No       | latest     | Specific block number if the user mentions one                        |
| seedLiquidity  | No       | true       | Set to false only if user says "empty testnet" or "no tokens"         |
| fundedAccounts | No       | 3          | Number of accounts (1-5) if user specifies                            |
| port           | No       | auto       | Specific port if user mentions one                                    |

## Workflow

### Step 1: Check Prerequisites

Before calling the MCP tool, verify the environment:

1. **Anvil availability**: The tool will return a clear error if Anvil is not installed. If you see `TESTNET_ANVIL_NOT_FOUND`, tell the user:
   ```
   Anvil (Foundry) is required but not installed.
   Install: curl -L https://foundry.paradigm.xyz | bash && foundryup
   ```

2. **Network access**: Fork mode requires network access to the chain's RPC. If you see `TESTNET_STARTUP_TIMEOUT`, suggest checking network connectivity or trying a different chain.

### Step 2: Extract Parameters

Parse the user's request for any specific requirements:

- Chain preference: "fork Base" → `forkFrom: "base"`
- Block number: "at block 19000000" → `blockNumber: 19000000`
- Account count: "5 test accounts" → `fundedAccounts: 5`
- No funding: "empty testnet" → `seedLiquidity: false`

If the user doesn't specify, use all defaults (fork Ethereum, 3 funded accounts, seed liquidity).

### Step 3: Call setup_local_testnet

Call `mcp__uniswap__setup_local_testnet` with the extracted parameters.

### Step 4: Present Results

Format the response as a rich summary:

```text
Local Testnet Ready

  RPC URL:    http://127.0.0.1:8545
  Chain ID:   31337
  Mode:       Fork of Ethereum at block 19,234,567

  Funded Accounts:
  ┌──────────────────────────────────────────────────────────────────────┐
  │ #  Address                                    ETH       USDC        │
  │ 1  0xf39Fd6e51aad88F6F4ce6aB8827279cffFb92266 10,000    1,000,000  │
  │ 2  0x70997970C51812dc3A010C7d01b50e0d17dc79C8 10,000    1,000,000  │
  │ 3  0x3C44CdDdB6a900fa2b585dd299e03d12FA4293BC 10,000    1,000,000  │
  └──────────────────────────────────────────────────────────────────────┘

  Key Contracts:
    V3Factory:                      0x1F98431c8aD98523631AE4a59f267346ea31F984
    NonfungiblePositionManager:     0xC36442b4a4522E871399CD717aBDD847Ab11FE88
    UniversalRouter:                0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD
    Permit2:                        0x000000000022D473030F116dDEE9F6B43aC78BA3
    QuoterV2:                       0x61fFE014bA17989E743c5F6cB21bF9697530B21e

  Available Pools (from fork):
    USDC/WETH 0.05% (V3)  — 0x88e6A0c2dDD26FEEb64F039a2c41296FcB3f5640
    USDC/WETH 0.30% (V3)  — 0x8ad599c3A0ff1De082011EFDDc58f1908eb6e6D8
    USDT/WETH 0.30% (V3)  — 0x4e68Ccd3E89f51C3074ca5072bbAC773960dFa36
    WBTC/WETH 0.30% (V3)  — 0xCBCdF9626bC03E24f779434178A73a0B4bad62eD

  Private Keys (for wallet config):
    Account #1: 0xac0974bec39a17e36ba4a6b4d238ff944bacb478cbed5efcae784d7bf4f2ff80
    Account #2: 0x59c6995e998f97a5a0044966f0945389dc9e86dae88c7a8412f4603b6b78690d
    Account #3: 0x5de4111afa1a4b94908f83103eb1f1706367c2e68ca870fc3fb9a804cdab365a
```

### Step 5: Suggest Next Steps

Always end with actionable follow-ups:

```text
  Next Steps:
  - Create a custom pool: "Create a WETH/DAI pool with thin liquidity"
  - Test time-dependent logic: "Advance time by 7 days"
  - Test a swap: "Get a quote for 1 WETH → USDC on the local testnet"
  - Fund more tokens: "Fund account #1 with 10,000 WBTC"
  - Configure your MCP server: Set RPC_URL_1=http://127.0.0.1:8545 in .env
```

## Important Notes

- **Anvil must be installed.** This skill requires Foundry's Anvil. If not installed, provide the installation command.
- **Fork mode requires network access.** The initial fork downloads state from the live chain's RPC. Subsequent operations are local.
- **Port conflicts are handled automatically.** If port 8545 is in use, the tool finds the next available port.
- **Previous testnets are cleaned up.** Starting a new testnet kills any existing one.
- **Private keys are Anvil defaults.** These are well-known test keys -- never use them on mainnet.
- **The testnet persists until the MCP server process exits** or a new testnet is started.

## Error Handling

| Error                          | User-Facing Message                                                      | Suggested Action                                                |
| ------------------------------ | ------------------------------------------------------------------------ | --------------------------------------------------------------- |
| `TESTNET_ANVIL_NOT_FOUND`      | "Anvil (Foundry) is not installed."                                      | Install: `curl -L https://foundry.paradigm.xyz \| bash && foundryup` |
| `TESTNET_STARTUP_TIMEOUT`      | "Anvil did not start within 30s. Fork RPC may be unreachable."           | Check network, try a different chain, or retry                  |
| `TESTNET_INVALID_FORK_CHAIN`   | "Chain X is not supported for forking."                                  | Use ethereum, base, arbitrum, optimism, or polygon              |
| `TESTNET_MOCK_NOT_IMPLEMENTED` | "Mock mode is not yet implemented."                                      | Use fork mode instead                                           |
| `TESTNET_SETUP_FAILED`         | "Failed to set up testnet: {reason}"                                     | Check Anvil installation and network access                     |
