---
name: session-log
description: Lightweight session logging for OpenClaw agents. Automatically creates a timestamped session file on every session start (including /new resets) and appends topic summaries during conversation. Solves the problem of /new overwriting session history — logs persist across resets and are readable by daily report crons. Use when setting up session continuity, conversation audit trails, or multi-agent daily summaries. Works for main, writer, coding, or any agent.
---

# Session Log

Lightweight session logging that survives `/new` resets.

## How It Works

- On every session start → create `sessions/YYYY-MM-DD_HH-MM_{agent}.md`
- During conversation → append a one-line summary after each meaningful topic
- Daily report / cron → glob `sessions/YYYY-MM-DD_*.md` to reconstruct the full day

## Session Startup (add to AGENTS.md)

```markdown
5. Create `sessions/YYYY-MM-DD_HH-MM_{agent}.md` (local time) for this session
```

Get current time and create the file:

```bash
python3 /path/to/skills/session-log/scripts/new_session.py --agent main --dir /path/to/workspace/sessions
```

Or manually:
```
# Session 2026-03-04 09:30 | main

## Log

```

## During Conversation

After each meaningful topic wraps up, append one line:

```bash
echo "- [topic] one-line summary" >> sessions/YYYY-MM-DD_HH-MM_{agent}.md
```

Keep it short — one line per topic, a dozen words max. This is a log, not a journal.

## Multi-Agent Setup

Each agent writes to **its own workspace** `sessions/` folder. The daily report reads all of them:

| Agent  | Path |
|--------|------|
| main   | `/path/to/main-workspace/sessions/` |
| writer | `/path/to/writer-workspace/sessions/` |
| coding | `/path/to/coding-workspace/sessions/` |

## Daily Report Integration

In the report cron's prepare step, glob today's session files from all agents:

```bash
ls /path/to/main-workspace/sessions/YYYY-MM-DD_*.md
ls /path/to/writer-workspace/sessions/YYYY-MM-DD_*.md
ls /path/to/coding-workspace/sessions/YYYY-MM-DD_*.md
```

Read each file and include summaries in the conversation recap section, tagged by agent (`[main]`/`[writer]`/`[coding]`).

## File Format

```markdown
# Session YYYY-MM-DD HH:MM | {agent}

## Log

- [topic-a] one-line summary
- [topic-b] one-line summary
```

## Helper Script

Use `scripts/new_session.py` to create the session file with correct timestamp:

```bash
python3 skills/session-log/scripts/new_session.py --agent main --dir workspace/sessions
```
