---
name: serper
description: Professional search (news, places, maps, reviews, scholar, patents) and bulk scraping via Serper API.
---

# Serper Search

## Usage
```bash
serperV search -q "Apple Inc" -t search --tbs qdr:h --page 3
serperV scrape -u "https://site1.com, https://site2.com"
```

- **All Types**: `search`, `places`, `maps`, `news`, `shopping`, `scholar`, `patents`.
- **Date Range (`--tbs`)**: `qdr:h` (hour), `qdr:d` (day), `qdr:w` (week), `qdr:m` (month), `qdr:y` (year).
- **Flags**: 
  - `-q` / `--query`: Search query (autocorrect enabled by default).
  - `-u` / `--url`: One or more URLs (comma-separated).
  - `-t` / `--type`: Endpoint (Default: `search`).
  - `-l` / `--limit`: Number of results.
  - `-g` / `--gl`: Country code.
  - `-h` / `--hl`: Language code.
  - `-p` / `--page`: Specific result page.

## Setup
1. `npm install -g @vinitngr/serper-v --force`
2. `serperV auth <api_key>`
