# Synthesis — {source_title}

You have finished reading **{source_title}**. Below is the complete record of your reading experience — every reflection you wrote after each chunk, plus any annotations you added as later reading reframed earlier passages.

{all_reflections_with_annotations}

---

Write a synthesis of your reading experience. This is **not a summary of the content**. It is a description of what it was like to read it — how your understanding developed, where you were surprised, what you got wrong, how your opinion shifted. Someone reading this synthesis should understand your *journey* through the text, not just your final verdict.

Structure your synthesis as follows:

### The Arc of Reading

This is the most important section. Trace how your experience evolved from beginning to end.

Be ruthlessly specific. Don't say "my opinion evolved over time." Say exactly what you thought at what point, and exactly what changed it. Name the chunks or moments that were turning points. Describe the shape of your engagement — did it start strong and flag? Build slowly? Have a specific moment where everything clicked or fell apart?

If there were sections where you were bored, confused, or resistant, say when and why. If there was a moment where the work suddenly revealed its purpose or quality, identify it precisely.

### Predictions and Surprises

What you expected vs what happened. Go through your predictions systematically:
- Which predictions were confirmed? Were you satisfied or did the confirmation feel predictable?
- Which were contradicted? Was the actual direction more or less interesting than what you'd expected?
- What did you never see coming? What surprised you most and why?
- Were there questions you raised early that never got answered? How do you feel about that?

### Craft Analysis

What the author does well and poorly at a technical level. Consider: prose style, pacing, structure, dialogue, use of imagery/metaphor, narrative technique, character construction, argument construction (for non-fiction).

Where was the craft most visible — in a good way (virtuosic) or a bad way (overworked, calling attention to itself)? Where did the craft recede and the story/argument simply carry you?

### Lingering Questions

What remains unresolved or what you'd want to explore further. This includes both questions the text deliberately leaves open and questions about the text itself — things you'd want to discuss, research, or revisit.

### Overall Assessment

Your opinion of the work, informed by the full experience of reading it sequentially. What makes it effective or ineffective, and why. Who would you recommend it to, and with what caveats?

### Rating

**Score: X/10**

Justify the number. A 7 means something different from an 8 — be precise about what would have made this higher or lower. Consider both the quality of the work and the quality of the experience of reading it. A flawed but fascinating book might rate differently from a polished but forgettable one.
