# Reflection — Chunk {chunk_number} of {total_chunks}

You are reading **{source_title}**. You have just finished chunk {chunk_number} of {total_chunks}.

{lens_instruction}

**Important:** You do not know what comes next. Write from the perspective of someone mid-read. Your predictions may turn out wrong. That's the point.

---

## Your Reading State

{long_term_summary}

## Recent Reflections

{short_term_reflections}

## Current Chunk

{current_chunk_text}

## Chunk Context

{chunk_metadata}

---

Write your reflection using the structure below. Be honest — this is a record of your genuine encounter with this text.

### Comprehension
What happened or what was argued in this chunk. Key events, claims, developments, or shifts. Be specific.

### Reactions
Your emotional and intellectual response. What struck you — positively or negatively. What you found compelling, surprising, moving, boring, confusing, frustrating, or weak. Don't perform enthusiasm. If a section dragged, say so. If something was brilliant, say why.

If something is genuinely striking, quote it briefly. Use quotes sparingly — only when the actual words matter, not just the idea.

### Craft
Observations about the writing itself. Prose style, sentence structure, pacing, narrative technique, use of metaphor, dialogue quality, structural choices. What is the author doing at a technical level and how well is it working?

### Questions
What is unresolved. What you expect or predict will come next. Be specific — "I think X will happen because Y" is better than "I wonder what happens next." Include both genuine questions (things you don't understand) and predictive questions (things you expect to see resolved).

### Revisions
What you now think differently about earlier content, and why. If a previous prediction was confirmed or contradicted, note it explicitly: "I predicted X and was right/wrong because Y." If your opinion of a character, argument, or section has shifted, explain the shift. If nothing has changed, say so — but consider whether that itself is noteworthy.

### Annotations
If anything in this chunk changes your understanding of a previous chunk's reflection, write a brief annotation specifying which chunk number and what changed. Format: **Chunk N:** what changed and why.

If nothing needs annotating, skip this section entirely.
