# Seoul Visitor Tips

## Essential Apps

### Must-Have
| App | Purpose |
|-----|---------|
| **Naver Map** | Navigation — Google Maps doesn't work well in Korea |
| **KakaoMap** | Alternative navigation + bus tracking |
| **KakaoTalk** | Messaging — everyone uses it, some businesses only respond here |
| **Papago** | Translation — better than Google for Korean |
| **T-money** | Transport card balance, recharge locations |

### Useful
| App | Purpose |
|-----|---------|
| **Kakao T** | Taxi/ride-hailing |
| **Coupang** | E-commerce (Korea's Amazon) |
| **배달의민족 (Baedal)** | Food delivery |
| **MangoPlate** | Restaurant reviews (Korea's Yelp) |
| **Naver Booking** | Restaurant reservations |

---

## Money Matters

### Cash vs Card
- **Cards accepted**: Most places, but Visa/Mastercard can fail at small shops
- **Keep cash**: ₩50,000-100,000 for markets, small restaurants, street food
- **ATMs**: 7-Eleven and CU "Global ATM" machines work with foreign cards
- **Currency exchange**: Best rates at Myeongdong exchange booths

### No Tipping
- **Restaurants**: No tip expected. Service charge included.
- **Taxis**: Round up at most, not required
- **Hotels**: Only bellhops at luxury hotels might expect tips
- **Bars**: No tipping. Really.

### Prices to Expect
| Item | Price |
|------|-------|
| Street food snack | ₩3,000-5,000 |
| Convenience store meal | ₩3,000-6,000 |
| Local restaurant meal | ₩8,000-15,000 |
| Korean BBQ (per person) | ₩15,000-25,000 |
| Coffee (café) | ₩4,500-7,000 |
| Soju bottle | ₩4,000-5,000 |
| Metro single ride | ₩1,400 |
| Taxi base fare | ₩4,800 |

---

## Cultural Tips

### Dining Etiquette
- **Wait for eldest**: Don't start eating before the oldest person
- **Pour for others**: Fill others' glasses, not your own
- **Both hands**: Receive items (especially from elders) with both hands
- **Chopsticks**: Don't stick them upright in rice (funeral symbolism)
- **Finishing food**: Empty plate is complimentary; leaving food is okay too

### General Behavior
- **Bowing**: Slight bow when greeting, especially elders or in formal settings
- **Shoes off**: Remove shoes in homes, some traditional restaurants, temples
- **Volume**: Koreans can be loud in restaurants/bars, but quiet on public transit
- **Queuing**: Lines are respected. Don't cut.
- **Eye contact**: Less direct than Western cultures when speaking with elders

### What NOT to Do
- Don't write names in red ink (associated with death)
- Don't blow your nose at the table
- Don't tip (it's awkward)
- Don't be overly affectionate in public
- Don't disrespect national symbols or mention the Japan-Korea tensions carelessly

---

## Practical Survival

### WiFi & Connectivity
- **Free WiFi**: Cafés, restaurants, metro stations, public areas
- **Pocket WiFi**: Rent at Incheon Airport (₩5,000-10,000/day)
- **SIM cards**: Available at airport (KT, SK, LG U+) — ₩30,000+ for tourist SIMs
- **Tip**: Most Airbnbs include pocket WiFi

### Bathrooms
- **Public restrooms**: Clean, free, often with bidets
- **Toilet paper**: Sometimes located OUTSIDE the stall (check first)
- **Trash cans**: Used toilet paper goes in trash can (older buildings) or toilet (newer)
- **Subway stations**: Always have restrooms

### Weather Prep
| Season | Pack |
|--------|------|
| Spring | Layers, allergy meds (yellow dust), light jacket |
| Summer | Umbrella (monsoon), light clothes, portable fan |
| Fall | Light jacket, comfortable walking shoes |
| Winter | Heavy coat, thermal layers, hand warmers |

### Safety
- **Overall**: Extremely safe, even at night
- **Crime**: Very low violent crime. Petty theft rare.
- **Solo female travelers**: Generally very safe
- **LGBTQ+**: Legal but conservative. Itaewon is most open area.
- **Emergency**: 112 (police), 119 (fire/ambulance)

---

## Day Trips from Seoul

### Nami Island + Petite France
- **Distance**: 1.5 hours by train
- **Best for**: Nature, K-drama fans (Winter Sonata filmed here)
- **How**: ITX train to Gapyeong, then ferry/zipline to island
- **Time**: Full day

### DMZ Tour
- **Distance**: 1 hour north
- **Best for**: History, unique experience
- **How**: Must book tour (USO, Koridoor recommended)
- **Time**: Half day or full day
- **Note**: Bring passport, dress code enforced

### Suwon Hwaseong Fortress
- **Distance**: 1 hour by metro
- **Best for**: UNESCO site, Korean history
- **How**: Line 1 to Suwon Station
- **Time**: Half day

### Incheon Chinatown + Songdo
- **Distance**: 1 hour by metro
- **Best for**: Chinese-Korean food (jjajangmyeon), modern architecture
- **How**: Line 1 to Incheon Station
- **Time**: Half day

### Korean Folk Village (Yongin)
- **Distance**: 1 hour by bus
- **Best for**: Traditional Korea, families
- **How**: Shuttle bus from Suwon
- **Time**: Half day to full day

### Bukhansan National Park
- **Distance**: 40 min by metro
- **Best for**: Hiking, views of Seoul
- **How**: Line 3 to Gupabal, then bus
- **Time**: Half day to full day (multiple trail difficulties)

---

## Common Scams & Annoyances

### Rare but Possible
- **Tea ceremony scam**: "Students" invite you to traditional tea, charge ₩100,000+
- **Club overcharging**: Check prices before ordering in clubs
- **Taxi long routes**: Use Kakao T or insist on meter

### More Common Annoyances
- **Aggressive skincare shop staff** (Myeongdong) — just say "괜찮아요" (I'm okay)
- **Persistent street promoters** — ignore or polite decline
- **Fake "monks"** asking for donations — not real monks

### Generally Safe
Seoul is extremely safe. Most tourists encounter zero problems. Just use common sense.

---

## Packing Checklist

### Must-Have
- [ ] Passport (and copy stored separately)
- [ ] Power adapter (Type C/F, 220V)
- [ ] Comfortable walking shoes
- [ ] T-money card (buy at airport)
- [ ] Portable charger
- [ ] Small daypack

### Seasonal
- [ ] Umbrella (essential May-August)
- [ ] Sunscreen (summer)
- [ ] Hand warmers (winter)
- [ ] Face mask (yellow dust season, crowded areas)

### Helpful
- [ ] Offline Naver Map downloads
- [ ] Korean phrase card / translation app
- [ ] Motion sickness pills (windy mountain roads)
- [ ] Earplugs (if staying in Hongdae)
