# Seoul Lodging Guide

## Best Areas to Stay

### Myeongdong (명동)
**Best for**: First-time visitors, shopping lovers, central location

| Pros | Cons |
|------|------|
| Walking distance to palaces | Tourist prices |
| Best K-beauty shopping | Crowded, noisy |
| Excellent metro connections | Generic hotel area |
| Street food paradise | Limited local vibe |

**Budget**: ₩60,000-100,000/night (guesthouses)
**Mid-range**: ₩150,000-250,000/night (business hotels)
**Luxury**: ₩300,000-500,000/night (Lotte, Shilla)

**Recommended**:
- *Budget*: Myeongdong Guesthouse, K-POP Hotel
- *Mid-range*: Nine Tree Premier Myeongdong, L7 Myeongdong
- *Luxury*: Lotte Hotel Seoul, The Plaza

---

### Hongdae (홍대)
**Best for**: Young travelers, nightlife, indie culture, budget-conscious

| Pros | Cons |
|------|------|
| Best nightlife area | Loud at night |
| Youth culture, street art | Far from traditional sites |
| Budget-friendly options | Weekend crowds intense |
| Great food scene | Party reputation |

**Budget**: ₩30,000-50,000/night (hostels)
**Mid-range**: ₩80,000-150,000/night (boutique hotels)
**Luxury**: ₩200,000-300,000/night (design hotels)

**Recommended**:
- *Budget*: Zzzip Guesthouse, Hongdae Family Housetel
- *Mid-range*: Ryse Autograph Collection, L7 Hongdae
- *Luxury*: Ryse Autograph Collection (top tier for area)

---

### Gangnam (강남)
**Best for**: Business travelers, modern Seoul, K-pop fans

| Pros | Cons |
|------|------|
| Business hotels | Far from historic sites |
| Modern, clean area | Less "tourist" attractions |
| Great restaurants | More expensive |
| Near COEX, Lotte Tower | Requires more metro time |

**Budget**: ₩70,000-100,000/night
**Mid-range**: ₩150,000-250,000/night
**Luxury**: ₩300,000-600,000/night

**Recommended**:
- *Mid-range*: Glad Live Gangnam, Novotel Ambassador
- *Luxury*: Park Hyatt Seoul, InterContinental COEX

---

### Itaewon (이태원)
**Best for**: International food lovers, LGBTQ+ travelers, diverse scene

| Pros | Cons |
|------|------|
| International atmosphere | Bar noise (Hamilton area) |
| Best Western food | Gentrifying rapidly |
| LGBTQ+-friendly | Steep hills |
| Near War Memorial | Tourist-focused dining |

**Budget**: ₩50,000-80,000/night
**Mid-range**: ₩120,000-200,000/night
**Luxury**: ₩350,000-700,000/night (Grand Hyatt)

**Recommended**:
- *Budget*: Itaewon G Guesthouse
- *Mid-range*: Hamilton Hotel, Ibis Styles
- *Luxury*: Grand Hyatt Seoul (hilltop views)

---

### Jongno/Insadong (종로/인사동)
**Best for**: Traditional Seoul, temple stays, cultural immersion

| Pros | Cons |
|------|------|
| Near all major palaces | Older hotel stock |
| Traditional atmosphere | Fewer modern amenities |
| Temple stay options | Quiet at night |
| Authentic hanok stays | Can feel dated |

**Budget**: ₩40,000-70,000/night (guesthouses)
**Mid-range**: ₩100,000-180,000/night (hanok stays)
**Luxury**: ₩250,000-400,000/night

**Recommended**:
- *Budget*: Sophia Guesthouse
- *Mid-range*: Hotel Gaon Jongno, Bukchon Hanok stays
- *Luxury*: Four Seasons Seoul

---

## Accommodation Types

### Hotels
- **5-star chains**: Park Hyatt, Four Seasons, Shilla, Lotte
- **Business hotels**: Novotel, Ibis, L7 series
- **Korean chains**: Best Western, Glad, Nine Tree

### Hanok Stays (한옥)
Traditional Korean houses converted to guesthouses
- **Experience**: Sleeping on floor (ondol heating), paper doors
- **Best areas**: Bukchon, Jongno, Insadong
- **Price**: ₩80,000-200,000/night
- **Book on**: Airbnb, Booking.com, or direct

### Goshiwon (고시원)
Small study rooms, originally for exam students
- **Reality**: Tiny rooms (2-3 pyeong), shared bathrooms
- **Price**: ₩300,000-500,000/month, ₩20,000-30,000/day
- **Good for**: Ultra-budget long stays
- **Note**: Claustrophobic, not for everyone

### Hostels
- Concentrated in Hongdae, Myeongdong
- Dorm beds: ₩15,000-30,000/night
- Private rooms: ₩40,000-70,000/night

### Airbnb/Officetel
- Common in all areas
- Studio apartments with kitchen
- ₩50,000-150,000/night depending on area
- **Note**: Some buildings don't allow short-term rentals

---

## Booking Tips

### Where to Book
1. **Booking.com** — Best for hotels, free cancellation
2. **Agoda** — Good prices for Asia
3. **Airbnb** — Apartments and hanok stays
4. **Yanolja/Yeogi** — Korean apps (Korean language, but cheaper)

### Price Patterns
- **Peak seasons**: Cherry blossom (April), fall foliage (October), holidays
- **Cheap periods**: Winter (Jan-Feb), monsoon (July)
- **Weekends**: 20-50% more expensive than weekdays

### Red Flags
- "Love motels" (모텔) are hourly hotels — fine for sleeping but often themed/garish
- Check reviews for noise (especially Hongdae, Itaewon)
- Verify Airbnb hosts are responsive (language barrier)

---

## Airport Connections

### Incheon Airport (ICN) — Main International
- **AREX Express**: 43 min to Seoul Station (₩9,500)
- **AREX All-stop**: 66 min to Seoul Station (₩4,750)
- **Airport bus**: Direct to major hotels/areas (₩15,000-17,000)
- **Taxi**: ₩65,000-80,000 to Seoul center (60-90 min)

### Gimpo Airport (GMP) — Domestic + Some International
- **Metro Line 5/9**: Direct to central Seoul (30-45 min)
- **AREX**: Connection to Seoul Station
- **Taxi**: ₩25,000-35,000 to Seoul center

### Recommended
- **Budget**: AREX All-stop + metro transfer
- **Convenience**: Airport bus to hotel area
- **Groups/Late night**: Taxi (split cost)
- **Pro tip**: Buy T-money at airport convenience store
