# Seoul Visa Guide

## Visa-Free Entry (K-ETA)

### K-ETA Countries
Most Western countries can enter visa-free with K-ETA:
- **Duration**: Up to 90 days
- **Purpose**: Tourism, business meetings
- **Cost**: ₩10,000 (~$7)
- **Processing**: 24-72 hours (apply before travel)

**K-ETA Required Countries** (partial list):
USA, UK, Canada, Australia, EU countries, Japan

**Apply**: k-eta.go.kr

### Visa-Free (No K-ETA Needed)
Some countries have bilateral agreements requiring no K-ETA.

---

## Work Visas

### E-7 (Skilled Worker)

**The standard work visa for professionals**

**Requirements**
- Bachelor's degree (or equivalent experience)
- Job offer from Korean company
- Employer sponsorship
- Salary meeting minimum thresholds

**Documents**
- Passport
- Degree certificate + apostille
- Employment contract
- Company registration documents
- Career certificates

**Duration**: 1-3 years, renewable
**Processing**: 2-4 weeks

### E-7-1 (IT Points-Based)

**Easier path for tech workers**

**Points System** (need 60/120)

| Category | Points |
|----------|--------|
| Age (25-35) | 15-20 |
| Master's degree | 15-20 |
| Bachelor's | 10-15 |
| Korean ability (TOPIK) | 5-20 |
| Years of experience | 5-25 |
| Salary level | 5-20 |
| Special achievements | Varies |

**Benefits**
- Faster processing
- More flexibility
- Can apply directly

### E-7-4 (Points System for Non-Professional)

For skilled workers without degrees — construction, manufacturing, etc.

---

## Other Visa Types

### D-2 (Student)

**For**: Full-time university/language students
- Can work part-time (20 hrs/week during semester)
- Must maintain enrollment
- Popular pathway to work visa

### D-4 (Language Training)

**For**: Korean language program students
- 6 months - 2 years
- Limited work rights
- Good for learning Korean before job hunting

### D-10 (Job Seeking)

**For**: Recent graduates or career changers

**Eligibility**
- D-2 holders graduating from Korean university
- Former E-7 holders
- Foreign degree + 1 year experience

**Duration**: Up to 2 years
**Work**: Part-time allowed (max 20 hrs/week)

### D-8 (Corporate Investment)

**For**: Starting a business

**Requirements**
- Minimum investment: ₩100M (~$74K)
- Can be less with TIPS or other programs
- Business plan required

### F-2-7 (Points Residency)

**For**: Long-term residence without employer sponsorship

**Points System** (need 80/120)

| Category | Points |
|----------|--------|
| Age | 0-25 |
| Education | 0-25 |
| Korean ability (TOPIK) | 0-25 |
| Income | 0-25 |
| Time in Korea | 0-20 |

**Benefits**
- No employer sponsorship needed
- Can change jobs freely
- Path to F-5

### F-5 (Permanent Residence)

**For**: Long-term commitment to Korea

**Pathways**
- 5+ years on F-2 with income requirements
- Investment immigration (₩500M+)
- Special contribution to Korea
- Marriage to Korean citizen (certain conditions)

### F-6 (Marriage)

**For**: Spouses of Korean citizens
- Work rights included
- Path to F-5 after 2 years
- Divorce can affect status (varies by situation)

---

## Golden Visa / Investment

### Investment Immigration

**Option 1**: ₩500M+ in designated funds
- 5-year investment
- F-2 visa → F-5 after 5 years
- Family included

**Option 2**: Real estate investment (limited)
- Previously available, currently restricted
- Check current policies

---

## Alien Registration Card (ARC)

### What It Is
Your Korean ID card — essential for daily life

### Getting Your ARC

**Timeline**: Apply within 90 days of arrival
**Where**: Local immigration office
**Processing**: 2-3 weeks

**Required For**
- Opening bank account
- Phone contract
- Apartment rental
- Many online services

### ARC Details
- 13-digit number (residence number)
- Valid until visa expires
- Must carry at all times (legally)
- Update address within 14 days of moving

---

## Visa Renewal & Change

### Renewal Process

**When**: 2-4 months before expiration
**Where**: Hi Korea (hikorea.go.kr) or immigration office
**Documents**: Updated employment, passport, ARC

**Processing Time**: 2-4 weeks

### Changing Status

**Common Changes**
- D-2 (student) → D-10 (job seeking) → E-7 (work)
- E-7 → F-2-7 (points residency)
- Any → F-6 (marriage)

**Process**
1. Apply for status change at immigration
2. Submit required documents
3. Interview (sometimes)
4. Receive new visa/ARC

---

## Practical Tips

### Immigration Offices

**Seoul Immigration Office**
- Location: Omokgyo Station (Line 5)
- Hours: 9 AM - 6 PM (Mon-Fri)
- Very busy — go early or book online

**Regional Offices**
- Incheon, Suwon, Sejong, etc.
- Often less crowded

### Online Services (Hi Korea)

**hikorea.go.kr**
- Book appointments
- Check application status
- Submit some applications online
- Renew ARC

### Tips

**Do**
- Apply early (2+ months before expiration)
- Keep all documents organized
- Notify of address changes
- Carry ARC always

**Don't**
- Overstay (serious consequences)
- Work outside visa permissions
- Let passport expire with valid visa
- Ignore immigration notices

### Exit Requirements

**Before Leaving Korea Permanently**
- Tax clearance certificate (for work visa holders)
- Close bank accounts
- Cancel phone contract
- Return ARC (or it expires automatically)

---

## Digital Nomad / Remote Work

### Current Status (2026)

**No official digital nomad visa yet**, but:

**Options**
1. **Tourist entry** — 90 days max, technically can't work
2. **D-10 visa** — If you qualify, allows part-time work
3. **F-2 visa** — If you have points, freelance possible
4. **Business visa discussions** — In progress

**Reality**
- Many remote workers use tourist visa
- Technically gray area
- Tax implications unclear
- No enforcement history for remote workers

**Future**
- Digital nomad visa under discussion
- May launch similar to other Asian countries
