# Seoul Transportation Guide

## Overview

Seoul has one of the world's best public transit systems. Cheap, clean, extensive, and efficient. Most residents don't need cars.

### Transit Comparison

| Mode | Coverage | Cost | Best For |
|------|----------|------|----------|
| **Metro** | Excellent | ₩1,400-2,400 | Most travel |
| **Bus** | Excellent | ₩1,200-2,400 | Areas without metro |
| **Taxi** | Excellent | ₩4,800+ | Late night, groups, convenience |
| **Bike** | Good | ₩1,000/hour | Short trips, Han River |
| **Car** | Not needed | Expensive | Families, suburbs |

---

## T-money Card (교통카드)

**Essential for all transit.** Buy at any convenience store.

### Getting Started
1. Buy T-money card (₩2,500-5,000 for card)
2. Load money (충전) at convenience store or machine
3. Tap on/tap off all transit
4. Refund unused balance when leaving

### Benefits
- **Discounts**: Transfer discounts between metro/bus
- **Convenience**: Works at convenience stores, vending machines
- **Speed**: Skip ticket lines

### Where to Buy
- **Convenience stores**: CU, GS25, 7-Eleven
- **Metro stations**: Vending machines
- **Airport**: Information desks

### Loading Money
- **Convenience store**: Tell cashier "충전해 주세요" + amount
- **Machine**: Insert card, select amount, pay cash
- **Amounts**: ₩1,000-500,000

---

## Metro (지하철)

### System Overview

| Stat | Number |
|------|--------|
| Lines | 23+ (including suburbs) |
| Stations | 700+ |
| Daily riders | 8+ million |
| Operating hours | 5:30 AM - midnight |
| Frequency | 2-6 minutes (peak), 5-10 minutes (off-peak) |

### Main Lines

| Line | Color | Key Stations |
|------|-------|--------------|
| **1** | Dark Blue | Seoul Station, Jongno, Dongdaemun |
| **2** | Green | Gangnam, Hongdae, Jamsil, City Hall |
| **3** | Orange | Gyeongbokgung, Apgujeong, Express Terminal |
| **4** | Light Blue | Myeongdong, Seoul Station, Dongdaemun |
| **5** | Purple | Gwanghwamun, Yeouido |
| **6** | Brown | Itaewon, World Cup Stadium |
| **7** | Olive | Gangnam, Express Terminal, Cheongdam |
| **9** | Gold | Express (강남-김포공항) |
| **Sinbundang** | Red | Gangnam to Pangyo (express) |
| **AREX** | Blue | Airport Express |

### Fares

| Distance | Price |
|----------|-------|
| 0-10 km | ₩1,400 |
| 10-50 km | +₩100 per 5 km |
| 50+ km | +₩100 per 8 km |

**Airport Express (AREX)**
- All-stop to Incheon: ₩4,750
- Express to Incheon: ₩9,500

### Tips
- **Rush hour**: 8-9 AM, 6-7 PM — extremely crowded
- **Women-only cars**: Pink marked areas during rush hour (optional)
- **End cars**: Usually less crowded
- **Phone service**: WiFi and cellular work in stations
- **Charging**: USB ports on many trains

### Navigation Apps
- **Naver Map**: Best for Korean transit
- **KakaoMap**: Alternative, also good
- **Google Maps**: Works but less accurate
- **Seoul Metro app**: Official, schedule info

---

## Buses (버스)

### Color Coding

| Color | Type | Use For |
|-------|------|---------|
| **Blue** | Trunk | Long distances across city |
| **Green** | Branch | Neighborhood connections to metro |
| **Yellow** | Circulation | Small areas, downtown loops |
| **Red** | Express | Suburbs, intercity |
| **Airport** | Airport | Direct airport routes |

### Fares
- **Blue/Green**: ₩1,200 (T-money), ₩1,400 (cash)
- **Red (Express)**: ₩2,400
- **Transfer discount**: Free within 30 min

### Using Buses
1. Enter front door
2. Tap T-money (or pay cash to driver)
3. Exit back door (some buses: any door)
4. Tap T-money on exit (important for transfers!)

### Tips
- **Naver Map**: Real-time bus tracking
- **Bus stop displays**: Show arrival times
- **Announce your stop**: Press button before stop
- **Cash**: Have exact change ready

---

## Taxis (택시)

### Types

| Type | Color | Base Fare | Notes |
|------|-------|-----------|-------|
| **Regular** | Orange/Silver | ₩4,800 | Most common |
| **Deluxe (모범)** | Black | ₩7,000 | Nicer, no bargaining |
| **Jumbo** | Black van | ₩7,000 | 6+ passengers |
| **International** | Orange | ₩4,800 | English-speaking (limited) |

### Fare Structure
- **Base**: ₩4,800 (first 1.6 km)
- **Distance**: ₩100 per 131 meters
- **Time**: ₩100 per 30 seconds (traffic)
- **Night surcharge**: +20% (midnight-4 AM)

### Typical Fares

| Route | Approximate Cost |
|-------|------------------|
| Gangnam → Hongdae | ₩15,000-20,000 |
| Itaewon → Gangnam | ₩8,000-12,000 |
| Seoul Station → Myeongdong | ₩5,000-7,000 |
| Incheon Airport → Seoul | ₩65,000-85,000 |

### Apps
- **Kakao T**: Most popular, reliable
- **Uber**: Works but less common
- **TADA**: Premium service
- **UT**: Budget alternative

### Tips
- **Use apps**: Easier than street hailing
- **Address in Korean**: Screenshot or Naver Map link
- **Payment**: Card usually works (some cash-only at night)
- **Receipts**: Press button for receipt (영수증)
- **Tipping**: Not expected

### Problems
- **Refusals**: Illegal but happens (use app instead)
- **Long route**: Use Naver Map to verify
- **No change**: Carry small bills

---

## Intercity Transportation

### KTX (High-Speed Rail)

| Destination | Time | Price |
|-------------|------|-------|
| Busan | 2h 30m | ₩59,800 |
| Daegu | 1h 40m | ₩43,500 |
| Gwangju | 1h 50m | ₩47,500 |
| Jeonju | 1h 30m | ₩34,600 |

**Departures**: Seoul Station, Yongsan Station
**Book**: Korail app, SRT app, or station

### Express Buses

| Terminal | Location | Destinations |
|----------|----------|--------------|
| **Express Bus Terminal** | Seocho | Most cities |
| **Dong Seoul** | Gangbyeon | East coast |
| **Sangbong** | Northeast | North regions |

**Book**: KobusTik app or terminal

### Domestic Flights

| Destination | Time | From |
|-------------|------|------|
| Jeju | 1h 10m | Gimpo |
| Busan | 55m | Gimpo |
| Daegu | 50m | Gimpo |

**Airlines**: Korean Air, Asiana, Jin Air, T'way, Jeju Air

---

## Bicycles (자전거)

### Ttareungi (따릉이) — Public Bike Share

**How to use**:
1. Download 따릉이 app
2. Register + pay
3. Find station on map
4. Scan QR code to unlock
5. Ride
6. Return to any station

**Pricing**
- 1 hour: ₩1,000
- 2 hours: ₩2,000
- Day pass: ₩5,000
- Monthly: ₩30,000 (unlimited 1-hour rides)

**Stations**: 2,500+ across Seoul

### Where to Ride
- **Han River parks**: Best cycling, flat paths
- **Cheonggyecheon**: Stream path through downtown
- **Seoul Forest**: Park area
- **City streets**: Bike lanes exist but traffic can be dangerous

---

## Driving

### Should You Drive?

**Probably not, because:**
- Traffic is severe
- Parking is expensive (₩3,000-5,000/hour in popular areas)
- Metro/taxi cheaper and easier
- Navigation confusing

**Maybe, if:**
- You have kids
- You live in suburbs
- You travel outside Seoul frequently
- Your company provides parking

### If You Must Drive

**License**
- International Driving Permit (IDP) + home license: Valid 1 year
- Korean license: Required for residents after 1 year

**Getting Korean License**
1. IDP holders: Simple written test
2. No IDP: Full process (written + practical)
3. Some countries: License exchange agreements

**Costs**
| Item | Monthly |
|------|---------|
| Car payment/lease | ₩300,000-700,000 |
| Insurance | ₩100,000-200,000 |
| Parking (monthly) | ₩100,000-300,000 |
| Gas | ₩150,000-300,000 |
| Tolls (if commuting) | ₩50,000-150,000 |

### Parking

**Types**
- **Building parking**: Usually first 30 min free
- **Public lots**: ₩2,000-5,000/hour
- **Street parking**: Blue lines, metered
- **Residential**: Monthly contracts ₩100,000-300,000

**Apps**
- **Kakao Navi**: Navigation
- **T-map**: Alternative navigation
- **Parking apps**: 파킹박, 모두의주차장

---

## Getting to/from Airports

### Incheon Airport (ICN)

| Method | Time | Cost | Notes |
|--------|------|------|-------|
| **AREX Express** | 43 min | ₩9,500 | To Seoul Station, no stops |
| **AREX All-stop** | 66 min | ₩4,750 | To Seoul Station |
| **Airport Bus** | 60-90 min | ₩15,000-17,000 | Direct to hotels/areas |
| **Taxi** | 60-90 min | ₩65,000-85,000 | Door to door |
| **KTX** | 1h 50m | ₩35,000 | To Busan directly from airport |

**Recommendation**: AREX to Seoul Station, then metro/taxi

### Gimpo Airport (GMP)

| Method | Time | Cost | Notes |
|--------|------|------|-------|
| **Metro Line 5/9** | 30-45 min | ₩1,400-2,400 | Direct to central Seoul |
| **AREX** | 20 min | ₩1,400 | To Seoul Station |
| **Taxi** | 30-50 min | ₩25,000-35,000 | Door to door |

**Recommendation**: Metro (much more convenient than ICN)
