# Seoul Tech Industry Guide

## Overview

Korea is a tech powerhouse — Samsung, LG, SK, Hyundai, plus internet giants Naver and Kakao. Seoul and nearby Pangyo form the tech hub.

### Tech Ecosystem

| Sector | Major Players |
|--------|---------------|
| **Hardware** | Samsung, LG, SK Hynix |
| **Internet** | Naver, Kakao |
| **Gaming** | Nexon, NCSoft, Krafton, Netmarble |
| **Fintech** | Toss, Kakao Pay, Naver Pay |
| **E-commerce** | Coupang, Naver Shopping, Gmarket |
| **Automotive** | Hyundai, Kia (mobility/EV) |

---

## Working in Korean Tech

### Company Types

**Chaebols (재벌)** — Large conglomerates
- Samsung, LG, SK, Hyundai
- Stable, hierarchical, traditional
- Long hours, rigid culture
- Good benefits, job security
- Korean language often required

**Internet Giants**
- Naver, Kakao
- More startup-like culture
- Better work-life balance than chaebols
- Some English-speaking roles

**Startups**
- Growing ecosystem
- More flexible culture
- Variable compensation
- Higher risk/reward

**International Companies**
- Google, Meta, Amazon, Microsoft
- Best for foreigners
- English-speaking environment
- Competitive packages

### Work Culture

**The Reality**
- Long hours still common (improving)
- Hierarchy matters (seniority-based)
- 회식 (hoeshik) — Work dinners with drinking
- 눈치 (nunchi) — Reading social cues essential
- Job hopping less accepted than in US

**Changing Trends**
- Younger companies more flexible
- Remote work growing (post-COVID)
- Work-life balance improving in tech
- MZ generation (밀레니얼+Z세대) pushing change

---

## Salaries

### Software Engineering

| Level | Annual (₩) | Monthly (₩) | USD Equivalent |
|-------|------------|-------------|----------------|
| Junior (0-2 yrs) | 40-55M | 3.3-4.5M | $30-41K |
| Mid (3-5 yrs) | 55-80M | 4.5-6.5M | $41-59K |
| Senior (6-10 yrs) | 80-120M | 6.5-10M | $59-89K |
| Principal/Staff | 120-180M | 10-15M | $89-133K |
| Director+ | 180M+ | 15M+ | $133K+ |

### By Company Type

| Company Type | Salary Range | Notes |
|--------------|--------------|-------|
| Samsung/LG | High base + bonus | 6-12 month bonus possible |
| Naver/Kakao | Competitive | RSUs, good benefits |
| Foreign tech | Highest | Best packages overall |
| Startups | Variable | Equity potential, lower base |
| Small companies | Lower | 40-60M typical |

### Compensation Components

**Base Salary** — 기본급
**Bonus** — 성과급 (0-12 months depending on company)
**Severance** — 퇴직금 (legally required, ~1 month/year)
**Stock/RSU** — Growing in tech companies
**Benefits** — Health insurance, pension, meals

---

## Tech Hubs

### Pangyo (판교)

**Korea's Silicon Valley**
- Location: 30 min south of Gangnam (Sinbundang Line)
- Companies: Naver, Kakao, NCSoft, Nexon, many startups
- Vibe: Modern campus-style offices
- Living: Bundang nearby, some live in Gangnam/Seocho

### Gangnam (강남)

- More traditional offices
- Many startups, VCs
- Good for networking
- Expensive but central

### Yongsan/Seoul Station

- Emerging tech area
- Government investment in development
- More affordable than Gangnam

### Incheon/Songdo

- International business district
- Some tech presence
- Free economic zone benefits

---

## Finding Jobs

### Job Boards

| Platform | Best For |
|----------|----------|
| **Wanted** | Tech jobs, startups |
| **Saramin** | All jobs (Korean-focused) |
| **JobKorea** | All jobs (Korean-focused) |
| **LinkedIn** | International companies |
| **Rocket Punch** | Startups |
| **People & Jobs** | Foreign workers |

### Strategies for Foreigners

**Best Path**
1. Target international companies (Google, Meta, etc.)
2. Target Korean companies with global teams
3. Network through tech meetups
4. Korean language helps significantly

**English-Only Roles**
- Exist but limited
- More common in: Gaming, international-facing roles
- Naver/Kakao have some English positions
- Startups with global focus

### Interview Process

**Typical Flow**
1. Resume screening
2. Coding test (often online)
3. Technical interviews (2-4 rounds)
4. Cultural fit interview
5. Offer negotiation

**Korean Company Specifics**
- May include personality tests
- Group interviews possible
- Background checks common
- Reference checks

---

## Visa for Tech Workers

### E-7 (Skilled Worker)

**Requirements**
- Bachelor's degree in relevant field
- Job offer from Korean company
- Company sponsors visa
- Salary meets minimum threshold

**Duration**: 1-3 years, renewable

### E-7-1 (IT Specialist)

**Points-based system** — Easier for tech workers
- Age, education, experience, Korean ability
- Minimum 60 points (out of 120)
- Faster processing
- More flexibility

### D-10 (Job Seeking)

**For**: Recent graduates, job hunters
- Up to 2 years to find work
- Can do part-time work
- Good for landing first job

### F-2-7 (Points Residency)

**Long-term option**
- Points-based
- No employer sponsorship needed
- Can change jobs freely
- Path to F-5 (permanent residence)

---

## Tech Community

### Meetups & Events

| Event | Focus |
|-------|-------|
| **Seoul Tech Meetup** | General tech networking |
| **Google Developer Group** | Google technologies |
| **AWS User Group** | Cloud |
| **Python Korea** | Python |
| **React Korea** | Frontend |
| **Startup Grind Seoul** | Startups |

### Coworking Spaces

| Space | Area | Notes |
|-------|------|-------|
| **WeWork** | Multiple | International standard |
| **Fast Five** | Multiple | Korean chain |
| **SparkPlus** | Multiple | Modern, popular |
| **HEYGROUND** | Seongsu | Social impact focus |
| **Maru 180** | Gangnam | Startup focused |

### Online Communities

- **Facebook groups**: Seoul Startups, Korea Tech Jobs
- **Slack**: Various tech Slack communities
- **Reddit**: r/korea, r/Living_in_Korea

---

## Starting a Company

### Startup Ecosystem

**Funding Landscape**
- Pre-seed: ₩100M-500M
- Seed: ₩500M-2B
- Series A: ₩2B-10B
- Growing VC presence

**Major VCs**
- SoftBank Ventures
- Kakao Ventures
- Naver D2SF
- Strong Ventures
- Primer

**Accelerators**
- SparkLabs
- Primer
- D.Camp
- Google for Startups

### Company Registration

**D-8 Visa** (Corporate Investment)
- Minimum investment: ₩100M (~$74K)
- Can be lower with certain conditions
- Allows you to work for your own company

**TIPS Program**
- Government support for startups
- Funding + mentorship
- Visa support included

---

## Pros & Cons

### Why Work in Korean Tech

✅ Lower taxes than US/Europe
✅ National health insurance (excellent)
✅ Low cost of living relative to salary
✅ Safe, clean city
✅ Excellent infrastructure
✅ Growing startup ecosystem
✅ Gateway to Asian market

### Challenges

❌ Language barrier (many roles require Korean)
❌ Work culture can be intense
❌ Hierarchy in traditional companies
❌ Lower absolute salaries than US
❌ Limited senior roles for foreigners
❌ Social integration can be difficult
