# Seoul Startup Guide

## Startup Ecosystem Overview

Korea's startup ecosystem has grown significantly, with Seoul and Pangyo as the main hubs.

### By the Numbers (2026)

| Metric | Value |
|--------|-------|
| Unicorns | 20+ |
| Annual VC investment | ~$10B |
| Startups registered | 70,000+ |
| Accelerators | 100+ |

### Notable Korean Startups

| Company | Sector | Status |
|---------|--------|--------|
| **Coupang** | E-commerce | Public (NYSE) |
| **Krafton** | Gaming | Public |
| **Toss** | Fintech | Decacorn |
| **Yanolja** | Travel | Unicorn |
| **Kurly** | Grocery | Unicorn |
| **Ridi** | Publishing | Unicorn |

---

## Starting Up in Seoul

### Legal Structure

**Most Common**: 주식회사 (Stock Company)

**Why**
- Required for most VC investment
- Familiar to investors
- Can issue stock options
- Clear governance structure

### Minimum Capital

**For Koreans**: ₩0 (technically)
**For foreigners (D-8 visa)**: ₩100M or qualify for exemption

**Exemptions**
- TIPS program
- Government accelerator programs
- Special partnerships

### Registration Time

| Step | Duration |
|------|----------|
| Name reservation | 1-2 days |
| Bank account | 1-3 days |
| Company registration | 3-5 days |
| Tax registration | 1-2 days |
| **Total** | 1-2 weeks |

---

## Funding

### Funding Stages

| Stage | Amount (₩) | Amount ($) |
|-------|------------|------------|
| Pre-seed | 100M-500M | $74K-370K |
| Seed | 500M-2B | $370K-1.5M |
| Series A | 2B-10B | $1.5M-7.4M |
| Series B | 10B-50B | $7.4M-37M |
| Series C+ | 50B+ | $37M+ |

### Major VCs

**Local**
| VC | Focus |
|----|-------|
| **Kakao Ventures** | Consumer, tech |
| **Naver D2SF** | Tech, AI |
| **SoftBank Ventures** | Growth stage |
| **Strong Ventures** | Tech, SaaS |
| **Primer** | Early stage |
| **Mashup Ventures** | Early stage |

**International (Active in Korea)**
- Sequoia (via scouts)
- Altos Ventures
- DST Global
- Tiger Global

### Government Funding

**Non-dilutive options**

| Program | Amount | Notes |
|---------|--------|-------|
| TIPS | Up to ₩500M | Matching fund |
| R&D grants | ₩100M-1B | Tech development |
| Seoul Business Agency | ₩50M-200M | Various programs |
| Export vouchers | ₩30M-100M | Global expansion |

---

## Accelerators & Incubators

### Top Programs

| Program | Stage | Notes |
|---------|-------|-------|
| **SparkLabs** | Seed | Tech focused, strong network |
| **Primer** | Pre-seed/Seed | Consumer, fintech |
| **D.Camp** | Early | Ecosystem hub |
| **Google for Startups** | Various | International |
| **K-Startup GC** | Early | For foreign startups |
| **Born2Global** | Growth | Global expansion |

### What You Get

**Typical Package**
- Office space (3-6 months)
- Mentorship
- ₩30M-100M investment
- Demo day access
- Network introductions

### K-Startup Grand Challenge

**For foreign startups**
- 3-month program
- Visa support (D-8)
- ₩50M+ funding potential
- Office in Seoul
- Government connections

**Apply**: k-startupgc.org

---

## Startup Hubs

### Pangyo (판교)

**Korea's Silicon Valley**
- Location: South of Seoul, Sinbundang Line
- Home to: Naver, Kakao, NCSoft, Nexon
- Vibe: Campus-style, modern
- Best for: Tech, gaming, AI

### Gangnam (강남)

- Traditional VC center
- Many startup offices
- Networking central
- More expensive

### Seongsu (성수)

- Creative startups
- D2C brands
- Younger, hipper
- Lower cost than Gangnam

### Coworking Spaces

| Space | Cost | Area |
|-------|------|------|
| WeWork | ₩500K+/desk | Multiple |
| Fast Five | ₩400K+/desk | Multiple |
| SparkPlus | ₩400K+/desk | Multiple |
| D.Camp | Free (accepted startups) | Gangnam |
| Maru 180 | Varies | Gangnam |

---

## Hiring

### Where to Find Talent

**Platforms**
- Wanted (tech-focused)
- Rocket Punch (startups)
- LinkedIn (international)
- Campus recruiting (top universities)

### Talent Pools

**Universities**
- KAIST, POSTECH (engineering)
- Seoul National University
- Yonsei, Korea University
- UNIST (AI, tech)

**From Corporations**
- Ex-Samsung, Naver, Kakao
- Often looking for startup culture
- Higher salary expectations

### Compensation

**Typical Startup Range**

| Role | Annual (₩) |
|------|------------|
| Junior developer | 40-55M |
| Senior developer | 70-100M |
| Product manager | 50-80M |
| Designer | 45-70M |
| Marketer | 40-65M |

**Stock Options**
- Growing acceptance
- Tax-advantaged framework exists
- Vest over 4 years typical

---

## Support Programs

### Government Programs

| Program | What You Get |
|---------|--------------|
| **TIPS** | ₩500M + mentoring |
| **K-Startup GC** | Visa + funding + office |
| **KISED** | Various support programs |
| **Seoul Business Agency** | Seoul-focused support |
| **Born2Global** | Global expansion |

### How to Apply

1. Check eligibility (sector, stage, nationality)
2. Prepare business plan (Korean often required)
3. Apply online
4. Interview/pitch
5. Due diligence
6. Funding decision

### Success Tips

✅ Korean co-founder helps
✅ Government connections matter
✅ Persistence — apply to multiple programs
✅ Show traction and metrics
✅ Local references valuable

---

## Challenges

### Common Difficulties

**For Foreign Founders**
- Language barrier
- Cultural differences
- Limited networks
- Visa complications
- Understanding regulations

**General**
- Intense competition
- High talent costs
- Long sales cycles (B2B)
- Conglomerate dominance in some sectors

### Mitigation

1. **Find local co-founder** — Invaluable
2. **Learn Korean** — Even basics help
3. **Join accelerator** — Built-in network
4. **Use KOTRA** — Free consulting
5. **Connect with expat founders** — Learn from experience

---

## Exit Paths

### IPO

**KOSDAQ** — Korean tech exchange
- More accessible than KOSPI
- Many tech IPOs
- Strong retail investor participation

**NYSE/NASDAQ**
- Coupang path
- Requires scale

### M&A

**Active Acquirers**
- Naver, Kakao (strategic)
- PE firms (financial)
- Korean conglomerates (strategic)
- Foreign tech companies

**Reality**
- M&A less common than US
- Strategic value often drives deals
- Cultural fit important

---

## Resources

### Communities

| Platform | Purpose |
|----------|---------|
| **Seoul Startups (FB)** | General community |
| **K-Startup Network** | Networking |
| **Startup Grind Seoul** | Events |
| **D.Camp events** | Ecosystem events |
| **SparkLabs network** | Alumni |

### Learning

- **Primer Academy** — Startup education (Korean)
- **Startup Alliance** — Reports, events
- **Seoul Business Agency** — Workshops

### Media

- **Platum** — Korean startup news
- **BeSUCCESS** — English startup news
- **Tech in Asia** — Regional coverage
