# Seoul Safety Guide

## Overall Safety

Seoul is one of the safest major cities in the world. Violent crime is rare, and you can walk most neighborhoods at any hour.

### Crime Statistics

| Crime Type | Seoul vs Western Cities |
|------------|------------------------|
| Violent crime | Much lower |
| Petty theft | Lower |
| Pickpocketing | Rare |
| Scams | Rare |
| Drug crime | Very rare (harsh penalties) |

### General Safety Tips
- **Late night**: Safe to walk in most areas
- **Belongings**: Can leave bags at cafés (though not recommended)
- **Public transit**: Very safe, even late
- **Solo female travelers**: Generally very safe

---

## Legal Considerations

### Laws to Know

**Drug Laws — Zero Tolerance**
- **ANY drug use = crime** (including marijuana)
- **Trace amounts** in system = possible prosecution
- **Using abroad** and returning = still prosecutable
- **Penalties**: 4+ years prison, deportation
- **Reality**: Random testing exists for foreigners

**Photography Laws**
- **Illegal**: Photographing people without consent
- **Illegal**: Taking photos in restricted areas (military, airports, government)
- **Illegal**: Upskirt/hidden camera photos (몰카) — severe penalties
- **Phones**: Shutter sound cannot be disabled (anti-molka measure)

**Defamation**
- **Truth is NOT a defense** — Stating true facts can be defamation
- **Online posts** about individuals/companies can result in lawsuits
- **Social media criticism** of Korea can cause problems
- **Advice**: Be careful what you post publicly

**Public Behavior**
- **Public intoxication**: Tolerated but not protected
- **Public urination**: Illegal, fines
- **Noise after 10 PM**: Can result in complaints/fines
- **Fighting**: Zero tolerance, both parties often arrested

### LGBTQ+ Considerations

**Legal Status**
- Not illegal (no anti-gay law)
- Not protected (no anti-discrimination law)
- Same-sex marriage not recognized

**Social Reality**
- Conservative society overall
- Young people more accepting
- Open LGBTQ+ scene in Itaewon (Homo Hill)
- Workplace: Coming out can be risky
- PDA: Avoid in public (same-sex)

**Advice**
- Itaewon = most open area
- Dating apps work (careful with privacy)
- Foreign communities more accepting
- Discretion recommended in professional settings

---

## Emergency Services

### Numbers to Know

| Service | Number | Notes |
|---------|--------|-------|
| **Police** | 112 | 24/7 |
| **Fire/Ambulance** | 119 | 24/7 |
| **Tourist Police** | 1330 | English available |
| **Immigration** | 1345 | Visa questions |

### Tourist Police
- **Locations**: Myeongdong, Itaewon, Hongdae, Dongdaemun
- **Languages**: English, Chinese, Japanese
- **Help with**: Translation, directions, minor issues

### If You're a Victim
1. **Go to police station** (파출소)
2. **Request translator** — Immigration can help
3. **Get incident report** (for insurance)
4. **Contact embassy** if serious

---

## Health Emergencies

### Hospitals with English Service

| Hospital | Area | Notes |
|----------|------|-------|
| **Severance Hospital** | Sinchon | Major, excellent English |
| **Samsung Medical Center** | Gangnam | Premium, good English |
| **Asan Medical Center** | Songpa | Large, English available |
| **International Clinic** | Itaewon | Expat-focused |
| **SNU Hospital** | Jongno | Research hospital |

### Pharmacies
- Called 약국 (yakguk)
- Many medications require prescription
- Pharmacists often speak some English
- Common medications available OTC:
  - Pain relievers (타이레놀)
  - Cold medicine
  - Basic antibiotics (some)

### Insurance
- **National Health Insurance**: If employed, automatic
- **Travel insurance**: Highly recommended for visitors
- **Hospital payment**: Often upfront, claim later

---

## Natural Disasters

### Earthquakes
- Korea has earthquakes but major ones rare
- Buildings are earthquake-resistant
- No special preparation needed for visitors

### Typhoons (Summer)
- Season: July-September
- Warnings through Emergency Alert System (loud phone alerts)
- Stay indoors during severe storms
- Check news for school/work closures

### Yellow Dust (황사)
- Season: March-May
- Fine dust from China/Mongolia
- Check 미세먼지 (fine dust) levels daily
- Wear KF94 masks when levels high
- Apps: 에어코리아, Airvisual

### Air Quality
- Seoul has air quality issues
- Worst: Winter and spring
- Check: AQI apps before outdoor activities
- Masks: KF94 widely available

---

## Specific Concerns

### Scams (Rare but Exist)

**Tea Ceremony Scam**
- "Students" invite you to "practice English"
- Take you to tea house
- Bill comes: ₩100,000+
- **Avoid**: Decline random invitations

**Bar Overcharging**
- Check prices before ordering
- Be cautious in foreigner-heavy nightlife areas
- Know your bill before paying

**Taxi Issues**
- Long routes (rare)
- Refusal to use meter (illegal)
- **Solution**: Use Kakao T app

### Women's Safety

**Generally Very Safe**
- Walk alone at night: Usually fine
- Public transit: Safe even late

**Concerns**
- **Molka (hidden cameras)**: Check for holes in bathrooms
- **Groping on transit**: Rare but happens (report immediately)
- **Drink spiking**: Extremely rare but be cautious

**Tips**
- Trust your instincts
- Women-only subway cars available (rush hour)
- Panic buttons on streets (blue pillars)

### Alcohol-Related Safety

**Drinking Culture**
- Heavy drinking normalized
- Know your limits
- Uber/Kakao T for getting home

**If Intoxicated**
- Passing out in public = not uncommon to see
- Police generally help, not harass
- Don't drive (zero tolerance DUI)

---

## Neighborhood Safety

### Very Safe (Anytime)
- Gangnam
- Seocho
- Jongno (palace areas)
- Bukchon
- Yeouido

### Safe (Normal Precautions)
- Hongdae
- Itaewon
- Sinchon
- Myeongdong

### Caution (Late Night)
- Jongno 3-ga (drunk crowds)
- Itaewon club areas (very late)
- Anywhere with lots of drunk people

### Notes
- Even "caution" areas are safer than most Western city nightlife
- No neighborhoods are truly dangerous
- Common sense applies

---

## Documentation

### Always Carry
- **ARC (Alien Registration Card)** — If resident
- **Passport copy** — If tourist
- **Insurance info** — Emergency access
- **Emergency contact** — Written down

### Digital Backups
- Photo of passport
- Insurance policy numbers
- Embassy contact info
- Emergency Korean phrases

---

## Embassy Information

| Country | Phone | Location |
|---------|-------|----------|
| **USA** | 02-397-4114 | Gwanghwamun |
| **UK** | 02-3210-5500 | Jeong-dong |
| **Canada** | 02-3783-6000 | Jung-gu |
| **Australia** | 02-2003-0100 | Gwanghwamun |
| **Germany** | 02-748-4114 | Hannam |

### What Embassies Help With
- Lost/stolen passports
- Arrest notification
- Emergency contacts home
- Major emergencies

### What They DON'T Help With
- Paying bills
- Legal representation
- Immigration issues
- Minor disputes
