# Moving to Seoul — Resident Guide

## Before You Arrive

### Documents to Bring

**Essential**
- Passport (valid 6+ months)
- Visa (if required)
- Employment contract
- University acceptance (students)
- Marriage certificate (if applicable)
- Degree certificates (authenticated/apostilled)

**Recommended**
- International Driving Permit
- Medical records
- Vaccination records
- Police clearance (some visas)
- Passport photos (bring many)

### Research Before Arrival

- Temporary accommodation (1-2 weeks)
- Neighborhood preferences
- Budget for deposits
- School options (if applicable)

---

## First Week Checklist

### Day 1-3

**Immediate Needs**
- [ ] Temporary accommodation check-in
- [ ] Buy SIM card or pocket WiFi
- [ ] Get T-money card (transportation)
- [ ] Exchange some cash
- [ ] Download essential apps (Naver Map, Papago, KakaoTalk)

### Day 4-7

**Essential Setup**
- [ ] Apply for ARC (Alien Registration Card)
- [ ] Open bank account (need ARC)
- [ ] Get phone plan (need ARC + bank)
- [ ] Start apartment hunting
- [ ] Register for health insurance

---

## Alien Registration Card (ARC)

### What It Is

Your Korean ID — essential for daily life.

### How to Get It

**Where**: Immigration office (Seoul: Omokgyo, Line 5)
**When**: Within 90 days of arrival
**Time**: 2-3 weeks processing

**Documents**
- Passport
- Application form
- Photo
- Proof of residence
- Visa-specific documents

**Cost**: ₩30,000

### What You Can Do With ARC

✅ Open bank account
✅ Get phone plan
✅ Rent apartment
✅ Register for health insurance
✅ Use online services
✅ Verify identity

---

## Finding an Apartment

### The Korean Rental System

**Jeonse (전세)**
- Large deposit (50-80% of home value)
- No monthly rent
- Deposit returned when you leave
- Requires significant capital

**Wolse (월세)**
- Smaller deposit (1-20 months rent)
- Monthly rent payment
- More accessible for foreigners
- More common for short-term

### Apartment Types

| Type | Description |
|------|-------------|
| **오피스텔** (Officetel) | Studio/1BR, building amenities |
| **아파트** (Apartment) | Korean-style condo, complexes |
| **빌라** (Villa) | Low-rise apartment building |
| **원룸** (One-room) | Studio apartment |
| **고시원** (Goshiwon) | Tiny rooms, very cheap |

### Finding Apartments

**Apps**
- 직방 (Zigbang) — Most popular
- 다방 (Dabang) — Alternative
- Naver Real Estate — Research

**Agents**
- 공인중개사 — Licensed real estate agents
- Commission: 0.3-0.5% of transaction

### Costs

**Upfront**
| Cost | Amount |
|------|--------|
| Deposit | 1-24 months rent |
| Agent fee | 0.5 month rent |
| Moving | ₩200,000-500,000 |

**Monthly**
| Cost | Amount |
|------|--------|
| Rent | Varies by area |
| 관리비 (Maintenance) | ₩50,000-200,000 |
| Utilities | ₩100,000-200,000 |

### Tips for Foreigners

- Some landlords hesitant with foreigners
- Agent can help negotiate
- Company sponsorship helps
- Short lease terms may be possible (premium)

---

## Banking

### Opening an Account

**Requirements**
- ARC
- Passport
- Proof of address
- Phone number

**Recommended Banks**
- KEB Hana — Best for foreigners
- Shinhan — Good network
- Woori — Government-connected

### Setting Up

1. Visit branch with documents
2. Create account (30-60 minutes)
3. Get debit card
4. Set up online banking
5. Download bank app

### Important

- Internet banking needs security tokens
- Apps require Korean ID verification
- International transfers possible but cumbersome

---

## Phone & Internet

### Phone Plan

**After ARC**
1. Visit carrier store (SK, KT, LG)
2. Choose plan
3. Need ARC, bank account
4. Contract typically 2 years

**Typical Plans**
| Data | Monthly |
|------|---------|
| 5GB | ₩40,000-50,000 |
| 15GB | ₩60,000-70,000 |
| Unlimited | ₩80,000-100,000 |

### Home Internet

**Setup**
- Call provider or visit store
- Same-day installation common
- ₩30,000-50,000/month
- Incredibly fast (world's fastest)

---

## Health Insurance

### National Health Insurance (NHI)

**Enrollment**
- Employees: Automatic through employer
- Self-employed: Register within 14 days of ARC
- Students: Register within 6 months

**Cost**
- ~7% of income (split with employer)
- Self-employed: varies, minimum ~₩100,000/month

**Coverage**
- Most medical services
- 20-50% copay typical
- Prescriptions covered

### Getting Started

1. Employer registers you, OR
2. Visit local NHIS office
3. Get NHIS card
4. Use at any hospital/clinic

---

## Settling In

### Things to Buy

**Essentials**
- Bedding (many apartments unfurnished)
- Kitchen basics
- Cleaning supplies
- Hangers, storage

**Where to Shop**
| Store | For |
|-------|-----|
| Daiso | Cheap basics |
| E-Mart/Homeplus | Groceries, household |
| IKEA | Furniture (Gwangmyeong) |
| Coupang | Online everything |

### Utilities Setup

**Usually automatic**:
- Electricity (KEPCO)
- Gas
- Water

**Transfer to your name**:
- Call providers or ask landlord
- Keep meter readings

### Address Registration

**Important**:
- Register address at immigration (within 14 days of moving)
- Update bank, phone, etc.
- Korean addresses: Building name + unit number

---

## Cultural Adjustment

### Expect

**Different**
- Social hierarchy
- Indirect communication
- Group-oriented culture
- Drinking culture
- Long work hours (if employed locally)

**Challenging**
- Language barrier
- Homogeneous society
- Bureaucracy
- Feeling like an outsider

### Tips

1. **Learn Korean** — Even basics help immensely
2. **Join communities** — Expat groups, sports, hobbies
3. **Be patient** — Adjustment takes 6-12 months
4. **Stay open** — Different ≠ wrong
5. **Take breaks** — Travel outside Korea occasionally

### Resources

- **Expat Facebook groups** — Advice, community
- **Korean classes** — Immersion helps
- **Counseling** — Available in English
- **Embassy events** — Networking

---

## Important Contacts

| Service | Number/Contact |
|---------|---------------|
| Emergency | 112 (police), 119 (fire/ambulance) |
| Immigration | 1345 |
| Tourist help | 1330 |
| NHIS | 1577-1000 |
| Your embassy | Check before arrival |

---

## Long-Term Planning

### Visa Renewal

- Track expiration dates
- Apply 2-4 months early
- Hi Korea for appointments

### Residency Path

**F-2 (Points-based)**
- After years of work
- No employer sponsorship needed
- More freedom

**F-5 (Permanent Residence)**
- After 5+ years
- Investment options
- Marriage route

### Exit Planning

**Before Leaving Korea**
- Tax clearance certificate
- Pension refund (if eligible)
- Cancel services
- Close bank accounts
- Notify immigration
- Get documents (employment proof, etc.)
