# Seoul Neighborhoods — Itaewon, Hannam, Yongsan

## Itaewon (이태원)

### The Vibe
Seoul's international district. Historically tied to the nearby US military base (Yongsan Garrison), Itaewon became the city's most diverse neighborhood. International restaurants, LGBTQ+ scene, expat bars, and increasingly, Korean young professionals seeking a different vibe. Think New York's East Village.

### Sub-Areas

**Main Itaewon (이태원역)**
- International restaurants everywhere
- Expat bars, clubs
- Busy main street (Itaewon-ro)
- Can feel touristy

**Haebangchon/HBC (해방촌)**
- Hillside neighborhood above Itaewon
- Indie cafés, craft beer, community feel
- More residential, artsy
- "Hipster Itaewon"

**Gyeongnidan-gil (경리단길)**
- Trendy street above Itaewon
- Upscale restaurants, boutiques
- Mix of Korean and international

**Homo Hill**
- LGBTQ+ district
- Bars, clubs, community
- Most openly LGBTQ+ area in Seoul

### Living in Itaewon

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩5-12M | ₩500K-900K |
| 1BR | ₩12-25M | ₩700K-1.3M |
| 2BR | ₩25-50M | ₩1-1.8M |

**Rent (Jeonse)**
| Type | Deposit |
|------|---------|
| Studio | ₩100-180M |
| 1BR | ₩180-300M |
| 2BR | ₩300-500M |

### Pros
- Best international food scene
- English everywhere
- Diverse community
- LGBTQ+-friendly
- Near Yongsan (major development)

### Cons
- Hilly (steep walks)
- Bar noise (Hamilton Hotel area)
- Gentrifying (prices rising)
- US military association (mixed feelings)
- Less "authentic Korean" experience

### Best For
- Expats wanting comfort
- LGBTQ+ community
- International food lovers
- Those who value diversity

---

## Hannam-dong (한남동)

### The Vibe
Upscale residential area adjacent to Itaewon. Diplomatic area (many embassies), international school families, wealthy Koreans. Quieter and more refined than Itaewon. Beautiful river-adjacent locations.

### Character
- Tree-lined streets
- Luxury apartments, villas
- Embassies and ambassador residences
- Boutique shops, galleries
- Home to HYBE (BTS's company) building

### Living in Hannam

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩10-20M | ₩700K-1.2M |
| 1BR | ₩20-40M | ₩1-1.8M |
| 2BR | ₩50-100M | ₩1.5-3M |

**Rent (Jeonse)**
| Type | Deposit |
|------|---------|
| 1BR | ₩200-350M |
| 2BR | ₩400-700M |
| 3BR+ | ₩700M-1.5B |

### Pros
- Quiet, safe, beautiful
- International school access
- Embassies nearby (good for visa stuff)
- River views available
- High-quality apartments

### Cons
- Expensive
- Can feel isolated
- Limited nightlife
- Requires car or taxi often
- Hills everywhere

### Best For
- Diplomatic families
- International school families
- High earners wanting quiet
- Those prioritizing quality of life

---

## Yongsan (용산)

### The Vibe
Major transformation underway. Former US military base land is being developed into massive mixed-use district. Yongsan Station is a major hub. Electronics markets (Yongsan Electronics Market) and growing tech presence. Think "up and coming" with huge potential.

### Sub-Areas

**Yongsan Station Area**
- Transportation hub (KTX to Busan)
- I'Park Mall
- Major development ongoing

**Yongsan Electronics Market**
- Multiple buildings of electronics
- Declining but still functional
- Cheaper phones, parts, repairs

**Ichon-dong (이촌동)**
- Residential, river views
- Japanese expat community
- Quieter, family-friendly

**National Museum Area**
- Large park, National Museum of Korea
- Spacious, green
- Good for families

### Living in Yongsan

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩5-10M | ₩450K-800K |
| 1BR | ₩10-20M | ₩600K-1.1M |
| 2BR | ₩20-40M | ₩900K-1.5M |

**Rent (Jeonse)**
| Type | Deposit |
|------|---------|
| Studio | ₩90-160M |
| 1BR | ₩160-280M |
| 2BR | ₩280-480M |

### Pros
- Central location
- Major transportation hub
- Affordable for central Seoul
- Future development = appreciation
- Han River access

### Cons
- Currently construction chaos
- Some areas feel empty
- Fewer dining/entertainment options (for now)
- US military base legacy (mixed)

### Best For
- People betting on appreciation
- Those who value central location
- Commuters (KTX access)
- Budget-conscious professionals

---

## Transit

### Metro Lines

| Line | Key Stations |
|------|-------------|
| Line 1 (Dark Blue) | Yongsan, Namyeong |
| Line 4 (Light Blue) | Sookmyung, Samgakji |
| Line 6 (Brown) | Itaewon, Hangangjin, Noksapyeong |
| Gyeongui-Jungang | Yongsan, Ichon |
| KTX | Yongsan Station |

### Commute Times

| From Itaewon | To | Time |
|--------------|-----|------|
| Itaewon | Gangnam | 15-20 min |
| Itaewon | Seoul Station | 10-15 min |
| Itaewon | Hongdae | 20-25 min |
| Yongsan | Busan | 2.5 hours (KTX) |

---

## Food & Nightlife

### Itaewon

**International**
- **Linus' BBQ** — American BBQ
- **Wolfhound** — Irish pub
- **Pasha** — Turkish/Mediterranean
- **Taco Bell** — Yes, the only one in Korea
- **Le Saint-Ex** — French bistro
- **Casablanca Sandwicherie** — Middle Eastern

**Korean**
- **Maple Tree House** — Korean BBQ (upscale)
- Multiple local joints in backstreets

**Nightlife**
- **Fountain** — Dance club
- **Contra** — Cocktail bar
- **Booth** — DJ bar
- **Queen, Why Not, Trance** — LGBTQ+ bars

### HBC/Gyeongnidan

- **Braai Republic** — South African BBQ
- **Magpie Brewing** — Craft beer pioneer
- **Passion 5** — Famous bakery/café
- **Tartine** — Brunch

### Hannam

- **Viva Polo** — Italian
- **Poom** — Contemporary Korean
- **Blue Bottle Coffee** — Famous location
- **HYBE Insight** — BTS museum/café

---

## Practical Info

### Groceries
- **High Street Market** — Imported goods (expensive)
- **Foreign Food Mart** — International groceries
- **E-Mart Yongsan** — Standard Korean mart
- **Costco** — Drive to Yangjae

### Healthcare
- **International Clinic** — English-speaking doctors
- **Severance Hospital** — Major hospital (Sinchon)

### Coworking
- **WeWork T Tower** — Yongsan
- **HEYGROUND** — Social impact focus
- **SparkPlus** — Multiple locations

### International Schools
- **Yongsan International School (YISS)**
- **Hannam/Itaewon area** — Close to multiple schools

---

## Community

**Expat Density**: Highest in Seoul

**Groups**
- **Seoul Expats** — Facebook group
- **InterNations Seoul** — Professional networking
- **Seoul LGBTQ+** — Community groups

**English-Friendly**: High — most restaurants, shops speak English

**Warning**: COVID-19 Itaewon cluster (2020) led to some stigma. Area recovered but some Koreans still associate it with that event.
