# Seoul Neighborhoods — Gangnam, Seocho, Samsung

## Gangnam (강남)

### The Vibe
The famous "Gangnam Style" district. Modern, wealthy, and business-oriented. South of the Han River (강남 literally means "south of the river"). This is corporate Seoul — Samsung HQ, major banks, luxury shopping. Think Manhattan's Midtown.

### Sub-Areas

**Gangnam Station Area (강남역)**
- Commercial heart, restaurants, bars, shopping
- Young professional crowd
- Busy, sometimes overwhelming
- Best for: Nightlife, dining, shopping

**Yeoksam (역삼)**
- Office buildings, startups, co-working spaces
- More residential than Gangnam Station
- Growing food scene
- Best for: Working professionals, startups

**Samsung/Samseong (삼성)**
- COEX Mall, Lotte World Tower
- Convention area, business hotels
- Best for: Business travelers, shoppers

**Apgujeong (압구정)**
- Old money, luxury boutiques, plastic surgery clinics
- K-pop entertainment companies nearby
- Best for: Luxury shopping, K-pop fans, food

**Cheongdam (청담)**
- Ultra-luxury, designer flagship stores
- Celebrity sightings, exclusive clubs
- Best for: High-end shopping, special occasions

### Living in Gangnam

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩10-20M | ₩800K-1.2M |
| 1BR | ₩20-40M | ₩1-1.8M |
| 2BR | ₩40-80M | ₩1.5-2.5M |

**Rent (Jeonse)**
| Type | Deposit |
|------|---------|
| Studio | ₩180-280M |
| 1BR | ₩280-450M |
| 2BR | ₩450-800M |

### Pros
- Best metro connectivity (Line 2, Sinbundang)
- Premium everything: gyms, cafés, restaurants
- Safe, clean, modern
- Easy Pangyo commute (Sinbundang Line)
- Career networking opportunities

### Cons
- Expensive — both rent and daily expenses
- Can feel corporate/soulless
- Less "authentic" Korean experience
- Competitive, status-conscious vibe
- Parking nightmare

### Best For
- Business professionals
- High earners
- People who want premium convenience
- Those working in Gangnam/Seocho offices

---

## Seocho (서초)

### The Vibe
Quieter, more residential version of Gangnam. Still wealthy but more family-oriented. Major courts, law firms, and some tech companies. Think upper-middle-class suburb within the city.

### Sub-Areas

**Seocho Station Area (서초역)**
- Law firms, government offices
- More residential than Gangnam Station
- Good restaurants, less nightlife

**Express Bus Terminal (고속터미널)**
- Underground shopping mall (Goto Mall)
- Transportation hub
- Department stores

**Banpo (반포)**
- Han River access, Banpo Hangang Park
- Luxury apartments
- Quieter, family-friendly
- Famous rainbow fountain

### Living in Seocho

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩10-18M | ₩700K-1.1M |
| 1BR | ₩15-35M | ₩900K-1.5M |
| 2BR | ₩35-70M | ₩1.3-2.2M |

**Rent (Jeonse)**
| Type | Deposit |
|------|---------|
| Studio | ₩150-250M |
| 1BR | ₩250-400M |
| 2BR | ₩400-700M |

### Pros
- Quieter than Gangnam, still convenient
- Good schools (public and private)
- Han River parks nearby
- More reasonable than Gangnam
- Easy Pangyo commute

### Cons
- Less nightlife
- Can feel suburban/boring
- Still expensive by Seoul standards
- Fewer expat-focused amenities

### Best For
- Families with older children
- Professionals wanting quiet
- Those working in Seocho/Pangyo
- Han River lifestyle lovers

---

## Samsung/Samseong (삼성/삼성동)

### The Vibe
Business and convention district. COEX Mall, Lotte World Tower, major hotels. Less residential, more commercial. Many businesspeople stay here temporarily.

### Key Features

**COEX Complex**
- Massive underground mall
- Starfield Library (Instagram famous)
- Aquarium, movie theaters
- Convention center

**Lotte World Tower**
- Tallest building in Korea (555m)
- Observation deck
- Luxury shopping
- Lotte World Mall

### Living in Samsung

Less common for long-term living due to commercial nature, but serviced apartments exist.

**Rent (Wolse)**
| Type | Deposit | Monthly |
|------|---------|---------|
| Studio | ₩15-25M | ₩900K-1.5M |
| 1BR | ₩25-50M | ₩1.2-2M |

### Pros
- Walking distance to COEX
- Major metro hub (Line 2, 9)
- Business amenities
- Hotel-quality living options

### Cons
- Expensive
- Not very residential
- Weekend crowds at COEX
- Lacks neighborhood feel

### Best For
- Business travelers on long assignments
- Those who prioritize convenience over community
- COEX/convention regulars

---

## Transit

### Metro Lines

| Line | Key Stations |
|------|-------------|
| Line 2 (Green) | Gangnam, Samseong, Jamsil, Sadang |
| Line 3 (Orange) | Apgujeong, Express Bus Terminal |
| Line 7 (Olive) | Cheongdam, Express Bus Terminal |
| Line 9 (Gold) | Sinnonhyeon, Express Bus Terminal |
| Sinbundang (Red) | Gangnam, Sinsa, to Pangyo |
| Bundang (Yellow) | Apgujeong-Rodeo, to Bundang |

### Commute Times

| From Gangnam | To | Time |
|--------------|-----|------|
| Gangnam | Seoul Station | 25-30 min |
| Gangnam | Hongdae | 30-35 min |
| Gangnam | Pangyo | 20-25 min (Sinbundang) |
| Gangnam | Jamsil | 15 min |
| Seocho | Gwanghwamun | 20-25 min |

---

## Food & Nightlife

### Gangnam Station
- **Gogung** — Best bibimbap chain
- **Maple Tree House** — Premium Korean BBQ
- **Clubbing**: Octagon, Arena (mega clubs)

### Apgujeong/Cheongdam
- **Mingles** — Michelin-starred modern Korean
- **Jungsik** — Fine dining Korean
- **Luxury bars**: speakeasies, hotel bars

### Seocho/Express Bus Terminal
- **Goto Mall** — Underground food court
- **Banpo Han River** — Convenience store chicken + beer (치맥)

---

## Schools Nearby

### International
- **Korea International School (KIS)** — Pangyo campus
- **Seoul International School (SIS)** — Seongnam
- **Dulwich College Seoul** — Seocho

### Korean Elite
- Multiple well-regarded 학원 (hagwon) districts
- Competitive private schools
