# Seoul Local Services Guide

## Banking

### Opening a Bank Account

**Requirements**
- ARC (Alien Registration Card) — Essential
- Passport
- Proof of address (utility bill, lease)
- Phone number (Korean)

**Major Banks**

| Bank | Notes |
|------|-------|
| **KEB Hana** | Good for foreigners, English service |
| **Shinhan** | Large network, reasonable service |
| **Woori** | Government-connected |
| **KB Kookmin** | Largest, sometimes difficult for foreigners |
| **NH (Nonghyup)** | Agricultural bank, widely available |

**Best for Foreigners**: KEB Hana or Shinhan — More experience with non-Korean customers

### Account Types

| Type | Korean | Use For |
|------|--------|---------|
| Savings | 저축예금 | Daily use, debit card |
| Salary | 급여계좌 | Receiving salary |
| Fixed deposit | 정기예금 | Higher interest |

### Banking Apps

- **Toss**: Modern banking app, works with multiple banks
- **KakaoBank**: Online-only bank, easy signup
- **Bank apps**: Each bank has own app

### ATMs

**Withdrawal Fees**
- Same bank: Free
- Different bank: ₩1,000-1,500
- International cards: ₩3,000-5,000

**Where to Find English ATMs**
- Convenience stores (7-Eleven, CU) — "Global ATM"
- Major bank branches
- Airports

### International Transfers

**Options**
| Service | Speed | Fee |
|---------|-------|-----|
| Bank wire | 2-3 days | ₩15,000-30,000 |
| Wise (TransferWise) | 1-2 days | ~1% |
| Remitly | 1-2 days | Varies |
| PayPal | Instant | 3-4% |

---

## Phone & Internet

### Getting a Korean Phone Number

**Options**

| Type | Requires | Best For |
|------|----------|----------|
| Prepaid SIM | Passport only | Tourists |
| Postpaid plan | ARC + bank account | Residents |
| MVNO (budget) | ARC | Budget-conscious |

**Major Carriers**
- **SK Telecom**: Largest, best coverage
- **KT (Korea Telecom)**: Good coverage, competitive pricing
- **LG U+**: Third largest, often cheapest

**Budget MVNOs**
- **Helloworld**: Budget-friendly
- **TWORLD**: SK's budget brand
- **U+ Prepaid**: LG's budget option

### Phone Plans

| Type | Data | Price |
|------|------|-------|
| Basic | 3-5 GB | ₩30,000-40,000 |
| Standard | 10-15 GB | ₩50,000-60,000 |
| Unlimited | Unlimited | ₩70,000-100,000 |

**What's included**: Usually unlimited calls/texts + data

### Home Internet

**Speed**: Korea has world's fastest internet

| Speed | Price |
|-------|-------|
| 100 Mbps | ₩20,000-30,000 |
| 500 Mbps | ₩30,000-40,000 |
| 1 Gbps | ₩40,000-50,000 |

**Providers**: KT, SK Broadband, LG U+

**Setup**: Usually same-day installation

---

## Postal Services

### Korea Post (우체국)

**Services**
- Domestic mail
- International shipping
- Banking services
- Bill payment

**Locations**: Every neighborhood has a post office

### Sending Mail

| Type | Domestic | International |
|------|----------|---------------|
| Letter | ₩380 | ₩500-700 |
| Package (1kg) | ₩3,000-5,000 | ₩15,000-30,000 |
| EMS (express) | ₩5,000+ | ₩25,000+ |

### Receiving Packages

**Delivery Companies**
- CJ Logistics (대한통운)
- Hanjin
- Lotte Global Logistics
- Coupang Rocket (fastest)

**Tracking**: All have apps/websites with tracking

**Delivery Notes**: Can request delivery to security desk, convenience store pickup, etc.

---

## Government Services

### Immigration Office

**Seoul Immigration Office**
- Location: Omokgyo Station (Line 5)
- Hours: 9 AM - 6 PM (Mon-Fri)
- Services: Visa extension, ARC, residence permit

**Online Services**: Hi Korea (hikorea.go.kr)
- Appointment booking
- Application status
- Some document submission

### Gu Office (구청) — District Office

**What you can do**:
- Resident registration
- Various certificates
- Tax payments
- Civil complaints

**Find yours**: Search "[Your neighborhood] 구청"

### Getting Documents

| Document | Where | Cost |
|----------|-------|------|
| Residence certificate | Gu office | ₩500 |
| Tax certificate | Gu office/NTS | ₩1,000 |
| ARC copy | Immigration | ₩10,000 |
| Police clearance | Police station | ₩2,000 |

---

## Healthcare Registration

### National Health Insurance

**Who's Covered**
- Employees: Automatic (employer registers)
- Self-employed: Must register within 14 days
- Students: Must register within 6 months

**Cost**: ~7% of income (split with employer if employed)

**Card**: NHIS card issued after registration

### Finding Doctors

**Apps/Websites**
- **Naver/KakaoMap**: Search 병원 (hospital) or 의원 (clinic)
- **Goodoc**: Book appointments
- **Hospital websites**: Many have English pages

**Types of Facilities**
| Type | Korean | For |
|------|--------|-----|
| Clinic | 의원 | Basic care, specialists |
| Hospital | 병원 | More serious issues |
| University hospital | 대학병원 | Complex cases |
| ER | 응급실 | Emergencies |

### Pharmacies (약국)

**Finding one**: Look for 약국 sign (green cross)
**Hours**: Most 9 AM - 9 PM, some 24-hour
**What you can buy**: Many medications require prescription

---

## Utilities Setup

### Electricity (전기)

**Provider**: KEPCO (Korea Electric Power)
**Setup**: Automatic with lease, call to transfer name
**Bill**: Monthly, ₩30,000-100,000 depending on usage
**Payment**: Auto-debit, convenience store, app

### Gas (가스)

**Provider**: City gas or propane (depends on building)
**Setup**: Call provider or landlord handles
**Bill**: Monthly, ₩20,000-80,000
**Winter warning**: Bills spike significantly

### Water (수도)

**Provider**: Seoul Waterworks
**Setup**: Usually included in management fee or separate
**Bill**: Bimonthly, ₩10,000-30,000

### Garbage/Recycling

**System**
- **General waste**: Special paid bags (종량제 봉투)
- **Recycling**: Separated by type (plastic, paper, glass)
- **Food waste**: Food waste bags (음식물쓰레기)

**Where to buy bags**: Convenience stores, supermarkets
**Bag costs**: ₩300-1,500 depending on size

**Recycling schedule**: Check your building or district website

---

## Daily Conveniences

### Convenience Stores (편의점)

**Chains**: CU, GS25, 7-Eleven, Ministop, Emart24

**What you can do**:
- Buy food, drinks, snacks
- Pay bills (유틸리티 요금)
- Send packages
- Print documents
- Charge T-money
- ATM (Global ATM for foreigners)
- Buy event tickets

**Hours**: Most 24/7

### Laundry

**Options**

| Type | Cost | Best For |
|------|------|----------|
| In-unit | — | Most apartments have washers |
| Coin laundry | ₩3,000-5,000/load | No washer, large items |
| Dry cleaning | ₩3,000-10,000/item | Suits, special items |
| Laundry service | ₩10,000-20,000/bag | Convenience |

**Note**: Dryers less common — hanging dry is normal

### Delivery Services

**Same-Day/Next-Day**
- **Coupang Rocket**: Often within hours
- **SSG**: Same-day in Seoul
- **Market Kurly**: Fresh food, overnight

**Regular**
- **GMarket/11st/Naver Shopping**: 1-3 days
- **Coupang**: 1-2 days

---

## Emergency Contacts Summary

| Service | Number |
|---------|--------|
| Police | 112 |
| Fire/Ambulance | 119 |
| Tourist Helpline | 1330 |
| Immigration | 1345 |
| NHIS (Health Insurance) | 1577-1000 |
| Electricity (KEPCO) | 123 |
| Gas Emergency | 1544-4500 |
| Water Emergency | 120 |
