# Seoul Expat Lifestyle Guide

## Expat Community

### Demographics

Seoul has a diverse expat community:
- **English teachers** — Large, active community
- **Tech workers** — Growing with startup scene
- **Corporate transferees** — Established networks
- **Students** — University programs
- **Military-affiliated** — Near Yongsan, Pyeongtaek

### Expat Hubs

| Area | Community |
|------|-----------|
| **Itaewon** | Most diverse, international food |
| **Hannam** | Upscale expats, diplomatic |
| **Hongdae** | Young expats, English teachers |
| **Pangyo/Bundang** | Tech workers, families |
| **Yongsan** | Military-connected, international schools |

### Finding Community

**Facebook Groups**
- Seoul Expats
- Seoul Foodies
- Hiking in Korea
- Seoul Tech Meetup
- Various nationality groups

**Apps/Platforms**
- Meetup.com — Various interest groups
- InterNations — Professional networking
- Bumble BFF — Finding friends

**Regular Events**
- Language exchange meetups
- Sports leagues (soccer, basketball, etc.)
- Professional networking events
- Cultural workshops

---

## Social Life

### Making Friends

**Korean Friends**
- Language exchange — Very popular
- Hobby groups — Hiking, sports, gaming
- Work colleagues — 회식 (work dinners)
- Dating apps — Some use for friendship

**Expat Friends**
- Easier initially (shared experience)
- Facebook groups, Meetup
- Sports leagues
- Church communities (large)

**Reality**
- Korean friendships take time
- Surface-level socializing is easy
- Deep friendships require investment
- Language helps significantly

### Dating

**Dating Apps**
| App | Users |
|-----|-------|
| **Tinder** | Mixed, tourists |
| **Bumble** | More serious |
| **Noondate** | Korean-focused |
| **Amanda** | Appearance-verified |
| **Hinge** | Growing |

**Korean Dating Culture**
- "Couple culture" is strong
- Matching outfits common
- 100-day anniversaries
- Meeting parents = serious

**For Foreigners**
- Language can be barrier
- Cultural differences exist
- Some fetishization (goes both ways)
- Serious relationships work

### Nightlife

**By Style**

| Scene | Area |
|-------|------|
| Clubbing | Hongdae, Gangnam |
| Bars, pubs | Itaewon, Hongdae |
| Jazz, live music | Hongdae, Itaewon |
| LGBTQ+ | Itaewon (Homo Hill) |
| Upscale | Cheongdam, Hannam |

**Club Entry**
- ID required (passport/ARC)
- Cover: ₩10,000-30,000
- Dress code at upscale venues
- Goes until 6 AM+

---

## Sports & Fitness

### Gyms

**Options**
| Type | Monthly |
|------|---------|
| Local gym | ₩50,000-80,000 |
| Chain (Fitness First, etc.) | ₩80,000-150,000 |
| Premium | ₩150,000-300,000 |
| Hotel gym (non-member) | ₩30,000/visit |

**Finding Gyms**
- Search 헬스장 on Naver Map
- Most neighborhoods have options
- English limited at local gyms

### Popular Sports

| Sport | Where |
|-------|-------|
| **Hiking** | Bukhansan, Gwanaksan, many more |
| **Running** | Han River paths |
| **Cycling** | Han River, dedicated paths |
| **Golf** | Driving ranges, courses outside Seoul |
| **Soccer** | Expat leagues, local teams |
| **Basketball** | YMCA, pickup games |
| **Climbing** | Indoor gyms popular |

### Hiking Culture

- Koreans love hiking (등산)
- Proper gear expected (full hiking outfits)
- Many accessible peaks near Seoul
- Makgeolli at summit is tradition

**Near Seoul**
| Mountain | Difficulty | Access |
|----------|------------|--------|
| Bukhansan | Moderate | Metro + bus |
| Gwanaksan | Moderate | Metro |
| Namsan | Easy | Walk from city |
| Achasan | Easy | Metro Line 5 |
| Inwangsan | Moderate | Bus |

---

## Wellness

### Jjimjilbang (찜질방)

**What it is**: Public bathhouse + sauna + sleeping area

**Experience**
1. Pay entry (₩12,000-20,000)
2. Get locker, change clothes
3. Bathe (naked, gender-separated)
4. Sauna rooms (various temperatures)
5. Common area (clothed, mixed)
6. Sleep overnight (optional)

**Famous Jjimjilbangs**
- Dragon Hill Spa (Yongsan) — Huge, foreigner-friendly
- Siloam Sauna (Seoul Station)
- Various local options

### Spas & Massage

| Type | Price |
|------|-------|
| Korean massage (안마) | ₩60,000-100,000/hour |
| Thai massage | ₩50,000-80,000/hour |
| Spa package | ₩100,000-300,000 |
| Hotel spa | ₩200,000+ |

### Yoga & Pilates

- Very popular in Korea
- ₩100,000-200,000/month typical
- Many studios in every neighborhood
- Some English-speaking options

---

## Entertainment

### K-Pop & Korean Entertainment

**Concert Tickets**
- Book through Interpark, Yes24
- Expensive and competitive
- Fan clubs get priority

**K-Pop Related**
- HYBE Insight (BTS museum)
- SM Entertainment area (Apgujeong)
- Music shows (live audience)
- Fan events

### Arts & Culture

| Venue | Type |
|-------|------|
| **Seoul Arts Center** | Performances, exhibitions |
| **National Museum** | Free, excellent |
| **Leeum Museum** | Modern art |
| **MMCA** | Contemporary art |
| **Theater district** | Korean musicals (Daehak-ro) |

### Movies

- CGV, Lotte Cinema, Megabox — Major chains
- ₩12,000-15,000 per ticket
- Many Hollywood films (subtitled)
- Korean cinema excellent

### Gaming

- PC방 (PC rooms) — Gaming cafés
- ₩1,000-2,000/hour
- E-sports events and venues
- Strong gaming culture

---

## Dining Culture

### Eating Alone (혼밥)

**Changing attitudes**
- Once stigmatized, now accepted
- 혼밥 (honbap) = eating alone
- Many restaurants accommodate solo diners
- Some still require 2+ people (BBQ)

### Delivery Culture

- Delivery everything
- Chicken, pizza, Korean food
- 배달의민족, Coupang Eats
- Free or cheap delivery
- To parks, anywhere

### Coffee Culture

- More cafés per capita than almost anywhere
- Café as workspace/social space
- Premium coffee prices (₩5,000-7,000)
- Stay as long as you want

---

## Pets

### Dog Ownership

**Considerations**
- Many apartments don't allow
- Small dogs more common
- Dog cafés popular
- Vet care available and good

**Costs**
| Item | Cost |
|------|------|
| Adoption | ₩0-500,000 |
| Purchase (breeds) | ₩500,000-3,000,000 |
| Vet visit | ₩30,000-100,000 |
| Monthly costs | ₩100,000-200,000 |

### Cat Ownership

- Similar considerations
- Cat cafés popular
- More accepted in apartments

### Importing Pets

- Microchip required
- Rabies vaccination
- Health certificate
- Quarantine possible (depends on origin)

---

## Religion

### Communities

**Christianity**
- Very active, many expat-friendly churches
- English services available
- Strong social communities

**Buddhism**
- Temple stays popular
- Open to foreigners
- Peaceful practice

**Islam**
- Seoul Central Mosque (Itaewon)
- Growing community
- Halal food in Itaewon

**Judaism**
- Chabad of Korea (Hannam)
- Small community

---

## Quality of Life

### Pros

✅ Safe (very low crime)
✅ Clean, organized
✅ Excellent public transit
✅ Amazing food scene
✅ Fast internet
✅ Healthcare quality
✅ Shopping convenience
✅ Four seasons

### Cons

❌ Language barrier
❌ Air quality issues
❌ Work culture (if employed locally)
❌ Homogeneous society
❌ Housing can be complex
❌ Cultural adjustment

### Adjustment Tips

1. **Learn Korean** — Even basics help hugely
2. **Find community** — Don't isolate
3. **Embrace culture** — Try everything
4. **Keep perspective** — Different ≠ wrong
5. **Stay healthy** — Physical and mental
