# Seoul Healthcare Guide

## Healthcare System Overview

Korea has universal healthcare through National Health Insurance (NHI). Quality is excellent, costs are low, and wait times are short.

### System Strengths

| Factor | Korea | US/UK Comparison |
|--------|-------|------------------|
| Quality | Excellent | Comparable to top systems |
| Cost | Low | Much cheaper |
| Wait times | Short | Much shorter |
| Technology | Advanced | On par or better |
| Accessibility | High | Very accessible |

---

## National Health Insurance (NHI)

### Who's Covered

**Mandatory enrollment**:
- All Korean citizens
- All foreigners staying 6+ months with eligible visa
- Dependents

### How to Enroll

**Employees**: Automatic through employer
**Self-employed/Others**: Register at NHIS within 14 days of ARC

**Registration**
- Location: Local NHIS office
- Documents: ARC, passport, visa
- Website: nhis.or.kr

### Cost

**Employees**
| Income | Total | Employee Share |
|--------|-------|----------------|
| Based on salary | ~7% | ~3.5% |

**Self-employed**
| Based on | Rate |
|----------|------|
| Income + assets | Varies, minimum ~₩100,000/month |

### What's Covered

| Coverage | Copay |
|----------|-------|
| Hospital outpatient | 30-50% |
| Hospital inpatient | 20% |
| Clinic visits | 30% |
| Prescriptions | 30% |
| Emergency | Varies |
| Preventive care | Free or low |

### What's NOT Covered (or Partial)

- Cosmetic procedures
- Some dental (implants, orthodontics)
- Non-essential treatments
- Single rooms (standard wards covered)
- Some advanced treatments

---

## Finding Healthcare

### Hospital Types

| Type | Korean | Use For |
|------|--------|---------|
| **Clinic** | 의원 | Basic care, specialists |
| **Hospital** | 병원 | More serious issues |
| **General Hospital** | 종합병원 | Complex care, multiple departments |
| **University Hospital** | 대학병원 | Most complex cases, research |

### Major Hospitals (English-Friendly)

| Hospital | Area | Notes |
|----------|------|-------|
| **Severance Hospital** | Sinchon | Excellent English service |
| **Samsung Medical Center** | Gangnam | Premium, good English |
| **Asan Medical Center** | Songpa | Largest, excellent |
| **Seoul National University Hospital** | Jongno | Top research hospital |
| **International Clinic** | Itaewon | Expat-focused |
| **Yonsei University Health System** | Multiple | International clinic |

### Finding Doctors

**Apps/Websites**
- **Naver/KakaoMap**: Search 병원 or specialty
- **Goodoc**: Book appointments
- **Hospital websites**: Many have English

**Search Terms**
| Specialty | Korean |
|-----------|--------|
| General/Internal | 내과 |
| Dental | 치과 |
| Eye | 안과 |
| ENT | 이비인후과 |
| Dermatology | 피부과 |
| Orthopedics | 정형외과 |
| OB/GYN | 산부인과 |
| Pediatrics | 소아과 |
| Psychiatry | 정신과 |

---

## Emergency Care

### Emergency Numbers

| Service | Number |
|---------|--------|
| **Emergency** | 119 |
| **Police** | 112 |
| **Tourist Help** | 1330 |

### Emergency Rooms

**Where to Go**
- 응급실 (eunggeupsil) = Emergency room
- Major hospitals have 24/7 ER
- Call 119 for ambulance

**Process**
1. Arrive or call 119
2. Triage assessment
3. Treatment
4. Pay before or after (depending on situation)
5. Insurance claim later if needed

**Cost**
- ER visit: ₩50,000-100,000 copay typical
- Ambulance: Free

---

## Pharmacies (약국)

### Finding Pharmacies

**Look for**: 약국 sign (green cross)
**Hours**: Most 9 AM - 9 PM, some 24-hour
**Near hospitals**: Always nearby

### What You Can Buy

**Over-the-Counter**
- Pain relievers (Tylenol = 타이레놀)
- Cold medicine
- Stomach medicine
- Vitamins
- Bandages, first aid

**Prescription Required**
- Antibiotics (mostly)
- Sleep aids
- Controlled substances
- Many medications that are OTC elsewhere

### Process

1. Get prescription from doctor
2. Take to any pharmacy
3. Pharmacist dispenses
4. Pay copay (usually 30%)

---

## Dental Care

### Coverage

**NHI Covers**
- Basic checkups
- Fillings
- Extractions
- Scaling (once/year)

**NHI Doesn't Cover (or Limited)**
- Implants
- Orthodontics
- Cosmetic dentistry
- Whitening

### Costs (With NHI)

| Treatment | Cost |
|-----------|------|
| Checkup | ₩10,000-20,000 |
| Cleaning/scaling | ₩15,000-30,000 |
| Filling | ₩30,000-80,000 |
| Root canal | ₩100,000-300,000 |
| Extraction | ₩30,000-100,000 |

### Costs (Not Covered)

| Treatment | Cost |
|-----------|------|
| Implant (one) | ₩1-2M |
| Orthodontics | ₩3-6M |
| Whitening | ₩200,000-500,000 |

### Finding Dentists

- Search 치과 on maps
- Many speak basic English
- No appointments needed for simple issues

---

## Mental Health

### Seeking Help

**Options**
| Type | Korean | Notes |
|------|--------|-------|
| Psychiatrist | 정신과 | Medical doctor, can prescribe |
| Psychologist | 심리상담사 | Therapy, no prescriptions |
| Counseling center | 상담센터 | General counseling |

### Coverage

- Psychiatry visits covered by NHI
- Therapy/counseling: Limited coverage
- Many expats use private therapists

### English-Speaking Options

| Provider | Notes |
|----------|-------|
| **Seoul Counseling Center** | Expat-focused |
| **The Mindbridge** | English therapy |
| **International Mental Health Korea** | Various services |
| **Online platforms** | BetterHelp works in Korea |

### Cultural Notes

- Mental health stigma exists (improving)
- Younger generation more accepting
- Workplace support growing

---

## Pregnancy & Childbirth

### Prenatal Care

**Coverage**: Well covered by NHI
**Process**: Register with OB/GYN, regular checkups
**Hospitals**: Most major hospitals have maternity wards

### Birth

**Costs (With NHI)**
| Type | Cost |
|------|------|
| Natural birth | ₩500,000-1M copay |
| C-section | ₩1-2M copay |
| Premium room | ₩100,000-500,000/night extra |

### Maternity Leave

- **Mother**: 90 days paid (60 days employer, 30 days government)
- **Father**: 10 days paid
- Both can take additional unpaid leave

---

## Health Checkups

### Annual Checkups (건강검진)

**NHI-Covered Checkups**
- Free every 2 years (40+)
- Free for employees (annual)
- Basic tests: Blood, urine, chest X-ray, etc.

**Premium Checkups**
- ₩500,000-2,000,000
- Comprehensive screening
- Popular at Samsung, Asan, etc.
- Same-day or next-day results

---

## Vaccinations

### Routine Vaccines

Available at:
- Public health centers (보건소) — cheapest
- Clinics
- Hospital

### Travel Vaccines

| Vaccine | Where |
|---------|-------|
| COVID-19 | Health centers, pharmacies |
| Flu | Clinics, pharmacies |
| Hepatitis | Travel clinics |
| Others | International clinics |

---

## Medical Tourism

### Why Korea?

- High quality, low cost
- Advanced plastic surgery
- Excellent dermatology
- Short wait times

### Popular Procedures

| Procedure | Cost (vs US) |
|-----------|--------------|
| LASIK | 50-70% cheaper |
| Dental implants | 50-70% cheaper |
| Plastic surgery | 30-50% cheaper |
| Health checkup | 50% cheaper |

### Areas

- **Gangnam**: Plastic surgery capital
- **Sinchon**: Severance medical complex
- **Songpa**: Asan Medical Center

---

## Private Insurance

### Do You Need It?

**NHI covers most needs**, but private insurance helps with:
- Single hospital rooms
- Non-covered treatments
- Lost income during illness
- Cancer treatment extras

### Options

| Type | Cost |
|------|------|
| Basic supplemental | ₩50,000-100,000/month |
| Comprehensive | ₩100,000-300,000/month |
| International plans | Varies |

### Providers

- Samsung Life, Hanwha, Kyobo (Korean)
- Cigna Global, Allianz (International)
