# Practical Dining in Seoul

## Dietary Considerations

### Vegetarian & Vegan

**The Challenge**
- Meat/fish stock in most soups and sauces
- Hidden anchovy/shrimp in banchan
- Animal products assumed default

**What Works**
| Dish | Notes |
|------|-------|
| **비빔밥** (Bibimbap) | Request no meat (고기 빼주세요) |
| **순두부** (Sundubu) | Some versions vegetarian |
| **잡채** (Japchae) | Glass noodles, can be meatless |
| **김치전** (Kimchi pancake) | Often vegetarian |
| **템플푸드** (Temple food) | Always vegan |

**Vegan-Friendly Restaurants**
| Restaurant | Area | Notes |
|------------|------|-------|
| **Osegye Hyang** | Insadong | Vegan Korean |
| **Plant Café** | Itaewon | Western + Korean vegan |
| **Loving Hut** | Multiple | Chain, Buddhist-run |
| **Balwoo Gongyang** | Jongno | Michelin temple food |

**Useful Phrases**
- 채식주의자예요 (I'm vegetarian)
- 고기 안 먹어요 (I don't eat meat)
- 생선도 안 먹어요 (I don't eat fish either)
- 육수에 고기 들어가요? (Does the broth have meat?)

### Halal

**Certified Halal**
| Restaurant | Area | Cuisine |
|------------|------|---------|
| **Makan** | Itaewon | Malaysian |
| **Kervan** | Itaewon | Turkish |
| **Busan Sikdang** | Itaewon | Korean |
| **Halal Guys** | Itaewon | American |

**Itaewon Mosque Area**
- Multiple halal restaurants nearby
- Seoul's main halal district
- Korean Muslim community center

**Tips**
- Look for "HALAL" certification signs
- Avoid Korean BBQ unless specifically halal
- Seafood-focused restaurants safer
- HalalKorea.com for directory

### Gluten-Free

**The Challenge**
- Soy sauce (간장) contains wheat
- Gochujang (고추장) often has wheat
- Most sauces cross-contaminated

**Safer Options**
| Dish | Notes |
|------|-------|
| **Plain grilled meat** | With salt only, no sauce |
| **Rice dishes** | Check sauce ingredients |
| **Samgyetang** | Usually gluten-free |
| **Fresh seafood** | Sashimi, raw preparations |

**Communication**
- 밀가루 알레르기 있어요 (I have wheat allergy)
- 간장 들어가요? (Does it have soy sauce?)
- Written card in Korean recommended

### Common Allergies

**How to communicate**:
1. Learn your allergen in Korean
2. Write it on phone/card
3. Show before ordering
4. Ask specifically

| Allergen | Korean |
|----------|--------|
| Peanut | 땅콩 (ttangkong) |
| Tree nuts | 견과류 (gyeongwaryu) |
| Shellfish | 조개류 (jogaeryu) |
| Shrimp | 새우 (saewu) |
| Sesame | 참깨 (chamkkae) |
| Egg | 계란 (gyeran) |
| Soy | 콩 (kong) |
| Wheat | 밀 (mil) |

---

## Alcohol Culture

### Drinking Etiquette

**The Rules**
1. **Never pour your own drink** — Others pour for you
2. **Use two hands** — When receiving from/pouring for elders
3. **Turn away from elders** — When drinking
4. **Don't refuse the first drink** — Accept, then pace yourself
5. **Match drinking pace** — Don't drink alone while others wait

**Business Drinking**
- 회식 (hoeshik) = work dinner with drinking
- Declining can hurt career (changing slowly)
- 2차, 3차 = "second round, third round"
- Know when you can leave (usually after 2차)

### What to Drink

| Drink | What It Is | ABV | Notes |
|-------|------------|-----|-------|
| **소주** (Soju) | Rice spirit | 16-20% | National drink, goes with everything |
| **맥주** (Maekju) | Beer | 4-5% | Cass, Hite, Terra (local), craft growing |
| **막걸리** (Makgeolli) | Rice wine | 6-8% | Milky, slightly sweet |
| **복분자주** | Berry wine | 15% | Sweet, for non-soju drinkers |
| **양주** (Yangju) | Whiskey | 40% | For occasions, expensive |

### Soju Variations

| Type | Notes |
|------|-------|
| **참이슬** (Chamisul) | Most popular, classic |
| **처음처럼** (Chum Churum) | Slightly sweeter |
| **좋은데이** (Good Day) | Fruit-flavored options |
| **진로** (Jinro) | Classic brand |
| **소맥** (Somaek) | Soju + beer mix |

### Drinking Spots

| Type | Korean | What to Expect |
|------|--------|----------------|
| **Hof** | 호프 | Beer hall, anju |
| **Pocha** | 포차 | Tent bar, street food |
| **Izakaya** | 이자카야 | Japanese-style, small plates |
| **Wine bar** | 와인바 | Upscale, Western style |
| **Makgeolli bar** | 막걸리집 | Traditional, pajeon (pancakes) |

---

## Practical Situations

### Making Reservations

**Apps**
- **Catch Table** — Fine dining
- **Naver Booking** — General
- **KakaoTalk** — Message restaurant directly

**Calling**
- Many restaurants prefer calls
- Staff may not speak English
- Have Korean speaker help if needed

**Walk-ins**
- Usually fine for casual restaurants
- Peak hours (12-1 PM, 7-9 PM) = wait
- Popular places = always wait

### Paying

**Methods**
| Method | Acceptance |
|--------|------------|
| Card | Most places |
| Cash | All places, sometimes required for small |
| Kakao Pay | Growing |
| Samsung Pay | Common |
| Apple Pay | Limited |

**No Tipping**
- Seriously, don't tip
- Service charge included
- Leaving money can cause confusion

**Splitting**
- Not traditional (one person pays)
- 각자 (gakja) = Dutch treat (use if needed)
- Fighting over the bill is normal

### Delivery

**Apps**
| App | Notes |
|-----|-------|
| **배달의민족** (Baedal) | Most popular, blue |
| **Coupang Eats** | Rocket delivery, fast |
| **요기요** (Yogiyo) | Alternative |

**Process**
1. Browse restaurants by area
2. Add items to cart
3. Pay via app
4. Track delivery
5. Receive at door (or building lobby)

**Minimums**
- Usually ₩10,000-15,000
- Delivery fee ₩0-4,000
- Peak hours = longer wait

### Food Safety

**General**
- Seoul food safety is excellent
- Street food is generally safe
- Tap water is drinkable (but most drink filtered)

**Concerns**
- Check expiration dates (유통기한)
- Avoid old seafood stands (trust your nose)
- Summer heat = faster spoilage

---

## Ramadan & Special Occasions

### Ramadan

**Iftar options**
- Itaewon halal restaurants
- Mosque area community iftars
- Some restaurants do special Ramadan menus

**Considerations**
- Most restaurants don't understand fasting
- Takeout/delivery for suhoor
- Seoul Central Mosque community support

### Chuseok (추석)

**Korean Thanksgiving (September/October)**
- Many restaurants closed
- Stock up on groceries
- Chain restaurants/hotels open
- Tourist areas operational

### Seollal (설날)

**Korean New Year (January/February)**
- Similar closures to Chuseok
- Traditional markets may close
- Plan meals in advance

---

## Useful Phrases for Dining

### Ordering
| English | Korean |
|---------|--------|
| Menu please | 메뉴판 주세요 |
| Water please | 물 주세요 |
| I'll have this | 이거 주세요 |
| One portion | 일인분 |
| Two portions | 이인분 |
| More banchan please | 반찬 더 주세요 |

### Preferences
| English | Korean |
|---------|--------|
| Less spicy please | 덜 맵게 해주세요 |
| No meat please | 고기 빼주세요 |
| Is this spicy? | 이거 매워요? |
| Delicious! | 맛있어요! |

### Finishing
| English | Korean |
|---------|--------|
| Check please | 계산이요 |
| Can I have a receipt? | 영수증 주세요 |
| Card payment | 카드 결제 |
| Cash payment | 현금 결제 |
| Takeout | 포장해 주세요 |
