# Seoul Food Overview

## The Korean Dining Experience

Korean food is designed for sharing. Most dishes come with banchan (반찬) — small side dishes that are free and refillable. Eating alone is becoming more accepted, but traditionally meals are communal.

### Meal Structure
- **Banchan**: Free side dishes (kimchi, pickled vegetables, etc.)
- **Main dish**: Ordered per person or to share
- **Rice**: Usually served separately
- **Soup**: Often included or ordered separately

### Price Tiers (Per Person)

| Tier | Price Range | What You Get |
|------|-------------|--------------|
| Budget | ₩5,000-10,000 | Kimbap, ramyeon, basic rice dishes |
| Mid-range | ₩10,000-20,000 | Korean BBQ (lunch), jjigae, most restaurants |
| Upscale | ₩20,000-50,000 | Premium BBQ, seafood, nicer restaurants |
| Fine dining | ₩50,000-200,000+ | Michelin stars, omakase, course meals |

---

## Essential Korean Dishes

### Must-Try

| Dish | What It Is | Where to Try |
|------|------------|--------------|
| **삼겹살 (Samgyeopsal)** | Grilled pork belly | Any 고기집 (BBQ restaurant) |
| **비빔밥 (Bibimbap)** | Mixed rice with vegetables, egg, gochujang | Jeonju-style restaurants |
| **김치찌개 (Kimchi-jjigae)** | Spicy kimchi stew | Any 백반 (home-style) restaurant |
| **불고기 (Bulgogi)** | Marinated beef | BBQ restaurants |
| **냉면 (Naengmyeon)** | Cold buckwheat noodles | Euljiro, traditional restaurants |
| **삼계탕 (Samgyetang)** | Ginseng chicken soup | Tosokchon, Baeknyeon Samgyetang |
| **떡볶이 (Tteokbokki)** | Spicy rice cakes | Street food, Sindang |
| **순두부찌개 (Sundubu-jjigae)** | Soft tofu stew | Any restaurant |
| **갈비 (Galbi)** | Grilled short ribs | Majang-dong, high-end BBQ |

### Beyond the Basics

| Dish | What It Is | Notes |
|------|------------|-------|
| **족발 (Jokbal)** | Braised pig's feet | Popular with soju |
| **보쌈 (Bossam)** | Boiled pork belly wraps | Wrapping meat in lettuce/kimchi |
| **칼국수 (Kalguksu)** | Hand-cut noodle soup | Comfort food |
| **해장국 (Haejangguk)** | Hangover soup | Morning after drinking |
| **순대 (Sundae)** | Korean blood sausage | Acquired taste, delicious |
| **치맥 (Chimaek)** | Fried chicken + beer | National pastime |

---

## Dining Culture

### What to Expect

**Banchan (반찬)**
- Free side dishes, always included
- Refillable — just ask "반찬 더 주세요"
- Usually 3-8 dishes
- Don't feel obligated to finish everything

**Table Setup**
- Metal chopsticks (harder than wooden)
- Spoons for rice and soup
- Often scissors for cutting meat
- Tongs at BBQ places

**Water/Drinks**
- Water is self-serve (물셀프)
- Look for the water dispenser
- Tea often free, sometimes costs

**Ordering**
- Call server: "저기요!" (jeogiyo!) or press button
- Many places have tablet ordering
- Some have Korean-only menus — use Papago/Google Lens

### Social Customs

**Drinking Etiquette**
- Pour for others, not yourself
- Receive drinks with both hands from elders
- Turn away from elders when drinking
- Saying no to soju is awkward (but manageable)

**Age/Hierarchy**
- Eldest person starts eating first
- Eldest person orders/pays (usually)
- Don't start eating until everyone is served

**Paying**
- Usually one person pays (not split)
- Offer to pay, but accept graciously if refused
- Dutch treat (각자) becoming more common among young people

---

## Restaurant Types

### 고기집 (Gogi-jip) — BBQ Restaurants
- Grill at your table
- Order by portion (인분)
- Typically 2+ person minimum
- Wrapping meat in lettuce = ssam (쌈)

### 백반집 (Baekban-jip) — Home-style
- Simple meals with multiple banchan
- Like Korean home cooking
- Usually very affordable

### 분식집 (Bunsik-jip) — Snack Restaurants
- Tteokbokki, kimbap, ramyeon
- Fast, cheap, casual
- Perfect for quick meals

### 포장마차 (Pojangmacha) — Tent Bars
- Street food stalls
- Tteokbokki, odeng (fish cake), soju
- Classic Korean experience
- Famous at Jongno 3-ga, Euljiro

### 술집 (Suljip) — Drinking Places
- Focus on anju (drinking food)
- Chicken, jokbal, dried snacks
- Go after dinner, not for meals

### 카페 (Cafe)
- Not just coffee — extensive dessert menus
- Study/work spots (공부카페)
- Stay as long as you want (usually)

---

## Finding Good Food

### Apps
| App | Best For |
|-----|----------|
| **MangoPlate** | Reviews (Korean Yelp) |
| **Naver Map** | Restaurant search + reviews |
| **KakaoMap** | Same, alternative |
| **배달의민족** | Delivery |
| **Coupang Eats** | Delivery alternative |

### Signs of Good Restaurants
- Long lines at meal times
- Koreans eating there (not just tourists)
- Simple, focused menu (specialists > generalists)
- Ajeossi (older men) eating alone at lunch
- Featured on TV (look for celebrity photos)

### Tourist Trap Signs
- English menu prominently displayed outside
- Hawkers calling tourists in
- Myeongdong/Insadong main streets
- "Authentic Korean BBQ" signs in English

---

## Quick Glossary

| Korean | Meaning |
|--------|---------|
| 맛있어요 (mashisseoyo) | It's delicious |
| 메뉴판 (menupan) | Menu |
| 주문할게요 (jumunhalgeyo) | I'd like to order |
| 계산이요 (gyesaniyo) | Bill please |
| 반찬 더 주세요 | More banchan please |
| 덜 맵게 해주세요 | Less spicy please |
| 포장 (pojang) | Takeout |
| 1인분 (il-inbun) | One portion |
| 2인분 이상 (2 inbun isang) | Minimum 2 portions |
